/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.modules.shipping.distance;

import com.google.maps.DistanceMatrixApi;
import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.model.Distance;
import com.google.maps.model.DistanceMatrix;
import com.google.maps.model.DistanceMatrixRow;
import com.google.maps.model.GeocodingResult;
import com.google.maps.model.LatLng;
import com.salesmanager.core.model.common.Delivery;
import com.salesmanager.core.model.merchant.MerchantStore;
import com.salesmanager.core.model.shipping.PackageDetails;
import com.salesmanager.core.model.shipping.ShippingConfiguration;
import com.salesmanager.core.model.shipping.ShippingOrigin;
import com.salesmanager.core.model.shipping.ShippingQuote;
import com.salesmanager.core.model.system.IntegrationConfiguration;
import com.salesmanager.core.model.system.IntegrationModule;
import com.salesmanager.core.modules.integration.IntegrationException;
import com.salesmanager.core.modules.integration.shipping.model.ShippingQuotePrePostProcessModule;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShippingDistancePreProcessorImpl
implements ShippingQuotePrePostProcessModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShippingDistancePreProcessorImpl.class);
    private static final String BLANK = " ";
    private static final String MODULE_CODE = "shippingDistanceModule";
    private String apiKey;
    private List<String> allowedZonesCodes = null;

    public List<String> getAllowedZonesCodes() {
        return this.allowedZonesCodes;
    }

    public void setAllowedZonesCodes(List<String> allowedZonesCodes) {
        this.allowedZonesCodes = allowedZonesCodes;
    }

    public void prePostProcessShippingQuotes(ShippingQuote quote, List<PackageDetails> packages, BigDecimal orderTotal, Delivery delivery, ShippingOrigin origin, MerchantStore store, IntegrationConfiguration globalShippingConfiguration, IntegrationModule currentModule, ShippingConfiguration shippingConfiguration, List<IntegrationModule> allModules, Locale locale) throws IntegrationException {
        if (delivery.getZone() == null) {
            return;
        }
        boolean zoneAllowed = false;
        if (this.allowedZonesCodes != null) {
            for (String zoneCode : this.allowedZonesCodes) {
                if (!zoneCode.equals(delivery.getZone().getCode())) continue;
                zoneAllowed = true;
                break;
            }
        }
        if (!zoneAllowed) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)delivery.getPostalCode())) {
            return;
        }
        Validate.notNull((Object)this.apiKey, (String)"Requires the configuration of google apiKey");
        GeoApiContext context = new GeoApiContext().setApiKey(this.apiKey);
        StringBuilder originAddress = new StringBuilder();
        originAddress.append(origin.getAddress()).append(BLANK).append(origin.getCity()).append(BLANK).append(origin.getPostalCode()).append(BLANK);
        if (!StringUtils.isBlank((CharSequence)origin.getState())) {
            originAddress.append(origin.getState()).append(BLANK);
        }
        if (origin.getZone() != null) {
            originAddress.append(origin.getZone().getCode()).append(BLANK);
        }
        originAddress.append(origin.getCountry().getIsoCode());
        StringBuilder destinationAddress = new StringBuilder();
        destinationAddress.append(delivery.getAddress()).append(BLANK);
        if (!StringUtils.isBlank((CharSequence)delivery.getCity())) {
            destinationAddress.append(delivery.getCity()).append(BLANK);
        }
        destinationAddress.append(delivery.getPostalCode()).append(BLANK);
        if (!StringUtils.isBlank((CharSequence)delivery.getState())) {
            destinationAddress.append(delivery.getState()).append(BLANK);
        }
        if (delivery.getZone() != null) {
            destinationAddress.append(delivery.getZone().getCode()).append(BLANK);
        }
        destinationAddress.append(delivery.getCountry().getIsoCode());
        try {
            GeocodingResult[] originAdressResult = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)context, (String)originAddress.toString()).await();
            GeocodingResult[] destinationAdressResult = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)context, (String)destinationAddress.toString()).await();
            if (originAdressResult.length > 0 && destinationAdressResult.length > 0) {
                LatLng originLatLng = originAdressResult[0].geometry.location;
                LatLng destinationLatLng = destinationAdressResult[0].geometry.location;
                delivery.setLatitude(String.valueOf(destinationLatLng.lat));
                delivery.setLongitude(String.valueOf(destinationLatLng.lng));
                DistanceMatrix distanceRequest = (DistanceMatrix)DistanceMatrixApi.newRequest((GeoApiContext)context).origins(new LatLng[]{new LatLng(originLatLng.lat, originLatLng.lng)}).destinations(new LatLng[]{new LatLng(destinationLatLng.lat, destinationLatLng.lng)}).awaitIgnoreError();
                if (distanceRequest != null) {
                    DistanceMatrixRow distanceMax = distanceRequest.rows[0];
                    Distance distance = distanceMax.elements[0].distance;
                    quote.getQuoteInformations().put("DISTANCE_KEY", 0.001 * (double)distance.inMeters);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while calculating the shipping distance", (Throwable)e);
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModuleCode() {
        return MODULE_CODE;
    }
}

