/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services;

import com.shopizer.search.services.GetResponse;
import com.shopizer.search.services.SearchRequest;
import com.shopizer.search.services.SearchResponse;
import com.shopizer.search.services.worker.KeywordIndexerImpl;
import com.shopizer.search.services.worker.ObjectIndexerImpl;
import com.shopizer.search.services.workflow.DeleteObjectWorkflow;
import com.shopizer.search.services.workflow.GetWorkflow;
import com.shopizer.search.services.workflow.IndexWorkflow;
import com.shopizer.search.services.workflow.SearchWorkflow;
import com.shopizer.search.utils.SearchClient;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchService {
    private static Logger log = Logger.getLogger(SearchService.class);
    @Autowired
    private DeleteObjectWorkflow deleteWorkflow;
    @Autowired
    private IndexWorkflow indexWorkflow;
    @Autowired
    private GetWorkflow getWorkflow;
    @Autowired
    private SearchWorkflow searchWorkflow;
    @Autowired
    private ObjectIndexerImpl index;
    @Autowired
    private KeywordIndexerImpl keyword;
    @Autowired
    private SearchClient searchClient;

    public void initService() {
        log.debug((Object)"Initializing search service");
        try {
            this.index.init(this.searchClient);
            this.keyword.init(this.searchClient);
        }
        catch (Exception e) {
            log.error((Object)"Cannot initialize SearchService correctly, will be initialized lazily", (Throwable)e);
        }
    }

    public void deleteObject(String index, String id) throws Exception {
        this.deleteWorkflow.deleteObject(index, id);
    }

    public GetResponse getObject(String index, String id) throws Exception {
        return this.getWorkflow.getObject(index, id);
    }

    public void index(String json, String index) throws Exception {
        this.indexWorkflow.index(json, index);
    }

    public SearchResponse searchAutoComplete(String index, String word, int size) throws Exception {
        return this.searchWorkflow.searchAutocomplete(index, word, size);
    }

    public SearchResponse search(SearchRequest request) throws Exception {
        return this.searchWorkflow.search(request);
    }
}

