/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.shopizer.search.services.Entry;
import com.shopizer.search.services.Facet;
import com.shopizer.search.services.GetResponse;
import com.shopizer.search.services.IndexKeywordRequest;
import com.shopizer.search.services.SearchHit;
import com.shopizer.search.services.SearchRequest;
import com.shopizer.search.services.SearchResponse;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.utils.SearchClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;

public class SearchDelegateImpl
implements SearchDelegate {
    private List<String> aggregationList;
    private SearchClient searchClient = null;
    private static Logger log = Logger.getLogger(SearchDelegateImpl.class);

    public List<String> getAggregationList() {
        return this.aggregationList;
    }

    public void setAggregationList(List<String> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public SearchClient getSearchClient() {
        return this.searchClient;
    }

    public void setSearchClient(SearchClient searchClient) {
        this.searchClient = searchClient;
    }

    private Object readNode(JsonElement jsonElement) throws Exception {
        HashMap container = null;
        if (jsonElement.isJsonObject()) {
            Set ens = ((JsonObject)jsonElement).entrySet();
            if (ens != null) {
                for (Map.Entry en : ens) {
                    if (container == null) {
                        container = new HashMap();
                    }
                    ((Map)container).put(en.getKey(), this.readNode((JsonElement)en.getValue()));
                }
            }
        } else if (jsonElement.isJsonArray()) {
            JsonArray jarr = jsonElement.getAsJsonArray();
            container = new ArrayList();
            for (JsonElement je : jarr) {
                ((List)((Object)container)).add(this.readNode(je));
            }
        } else if (!jsonElement.isJsonNull() && jsonElement.isJsonPrimitive()) {
            container = jsonElement.getAsString();
        }
        return container;
    }

    public static Map<String, Object> toMap(JsonObject object) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set keys = object.keySet();
        for (String key : keys) {
            Object value = object.get(key);
            if (value instanceof JsonArray) {
                value = SearchDelegateImpl.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                value = SearchDelegateImpl.toMap((JsonObject)value);
            } else if (value instanceof JsonPrimitive) {
                value = ((JsonPrimitive)value).getAsString();
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JsonArray array) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            Object value = array.get(i);
            if (value instanceof JsonArray) {
                value = SearchDelegateImpl.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                value = SearchDelegateImpl.toMap((JsonObject)value);
            } else if (value instanceof JsonPrimitive) {
                value = ((JsonPrimitive)value).getAsString();
            }
            list.add(value);
        }
        return list;
    }

    @Override
    public boolean indexExist(String indexName) throws Exception {
        RestHighLevelClient client = this.searchClient.getClient();
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        boolean exists = client.indices().exists(request, RequestOptions.DEFAULT);
        return exists;
    }

    @Override
    public void createIndice(String mapping, String settings, String indexName) throws Exception {
        CreateIndexResponse createIndexResponse;
        RestHighLevelClient client = this.searchClient.getClient();
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        if (!StringUtils.isBlank((CharSequence)settings)) {
            request.settings(settings, XContentType.JSON);
        }
        if (!StringUtils.isBlank((CharSequence)mapping)) {
            request.mapping(mapping, XContentType.JSON);
        }
        if (!(createIndexResponse = client.indices().create(request, RequestOptions.DEFAULT)).isAcknowledged()) {
            log.error((Object)("An error occured while creating an index " + indexName));
        }
    }

    @Override
    public void index(String json, String collection, String id) throws Exception {
        RestHighLevelClient client = this.searchClient.getClient();
        IndexRequest request = new IndexRequest(collection);
        request.id(id);
        request.source(json, XContentType.JSON);
        IndexResponse response = client.index(request, RequestOptions.DEFAULT);
        if (response.getResult() != DocWriteResponse.Result.CREATED && response.getResult() != DocWriteResponse.Result.UPDATED) {
            log.error((Object)("An error occured while indexing a document " + json + " " + response.getResult().name()));
        }
    }

    @Override
    public void delete(String collection, String id) throws Exception {
        DeleteRequest request;
        RestHighLevelClient client;
        DeleteResponse deleteResponse;
        ReplicationResponse.ShardInfo shardInfo;
        if (this.indexExist(collection) && (shardInfo = (deleteResponse = (client = this.searchClient.getClient()).delete(request = new DeleteRequest(collection, id), RequestOptions.DEFAULT)).getShardInfo()).getFailed() > 0) {
            log.error((Object)("An issue occured while deleting document with id " + id + " from index " + collection));
        }
    }

    @Override
    public void bulkDeleteIndex(Collection<String> ids, final String collection) throws Exception {
        if (this.indexExist(collection)) {
            RestHighLevelClient client = this.searchClient.getClient();
            ActionListener<DeleteResponse> listener = new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                }

                public void onFailure(Exception e) {
                    log.error((Object)("An issue occured while deleting document from index " + collection + " " + e.getMessage()));
                }
            };
            if (ids != null && ids.size() > 0) {
                for (String id : ids) {
                    DeleteRequest request = new DeleteRequest(collection, id);
                    client.deleteAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
                }
            }
        }
    }

    @Override
    public void bulkIndexKeywords(Collection<IndexKeywordRequest> bulks, final String collection) throws Exception {
        RestHighLevelClient client = this.searchClient.getClient();
        ActionListener<IndexResponse> listener = new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
            }

            public void onFailure(Exception e) {
                log.error((Object)("An issue occured while indexing document from index " + collection + " " + e.getMessage()));
            }
        };
        for (IndexKeywordRequest key : bulks) {
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{\"_id_\":").append("\"").append(key.getId()).append("\",").append("\"original\":").append("\"").append(key.getOriginal()).append("\",").append("\"keyword\":").append("\"").append(key.getKeyword()).append("\"}");
            IndexRequest request = new IndexRequest(collection);
            request.source(jsonBuilder.toString(), XContentType.JSON);
            client.indexAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    @Override
    public GetResponse getObject(String index, String id) throws Exception {
        GetRequest getRequest;
        RestHighLevelClient client = this.searchClient.getClient();
        org.elasticsearch.action.get.GetResponse getResponse = client.get(getRequest = new GetRequest(index, id), RequestOptions.DEFAULT);
        if (getResponse.isExists()) {
            JsonParser parser = new JsonParser();
            JsonObject crunchifyObject = (JsonObject)parser.parse(getResponse.getSourceAsString());
            Map<String, Object> fields = SearchDelegateImpl.toMap(crunchifyObject);
            GetResponse response = new GetResponse(fields);
            response.setObjectJson(getResponse.getSourceAsString());
            return response;
        }
        log.error((Object)("Object not found on collection " + index + " from id " + id));
        return null;
    }

    @Override
    public Set<String> searchAutocomplete(String indexName, String keyword, int size) throws Exception {
        HashSet<String> keywords = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)keyword)) {
            return keywords;
        }
        keyword = keyword.trim();
        RestHighLevelClient client = this.searchClient.getClient();
        org.elasticsearch.action.search.SearchRequest searchRequest = new org.elasticsearch.action.search.SearchRequest(new String[]{indexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        SuggestionBuilder termSuggestionBuilder = SuggestBuilders.completionSuggestion((String)"keyword").text(keyword);
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("keyword-suggest", termSuggestionBuilder);
        searchSourceBuilder.suggest(suggestBuilder);
        searchRequest.source(searchSourceBuilder);
        org.elasticsearch.action.search.SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error((Object)("Cannot search in index [" + indexName + "] index might not exist "), (Throwable)e);
            return keywords;
        }
        if (searchResponse == null) {
            log.warn((Object)"Empty searchResponse");
            return keywords;
        }
        RestStatus status = searchResponse.status();
        if (status.getStatus() != 200) {
            throw new Exception("Ann error occured when searching index " + indexName + " " + status.getStatus());
        }
        Suggest suggest = searchResponse.getSuggest();
        CompletionSuggestion completionSuggestion = (CompletionSuggestion)suggest.getSuggestion("keyword-suggest");
        for (CompletionSuggestion.Entry entry : completionSuggestion.getEntries()) {
            for (CompletionSuggestion.Entry.Option option : entry) {
                Map originalFields = option.getHit().getSourceAsMap();
                String suggestText = (String)originalFields.get("original");
                keywords.add(suggestText);
            }
        }
        return keywords;
    }

    @Override
    public SearchResponse search(SearchRequest request) throws Exception {
        RestHighLevelClient client = this.searchClient.getClient();
        String index = null;
        if (!CollectionUtils.isEmpty(request.getCollections())) {
            index = request.getCollections().get(0);
        }
        if (!StringUtils.isBlank((CharSequence)request.getIndex())) {
            index = request.getIndex();
        }
        org.elasticsearch.action.search.SearchRequest searchRequest = new org.elasticsearch.action.search.SearchRequest(new String[]{index});
        MultiMatchQueryBuilder qb = new MultiMatchQueryBuilder((Object)request.getMatch(), new String[]{"name", "description", "categories", "manufacturer", "tags"});
        qb.fuzziness((Object)Fuzziness.AUTO);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)qb);
        if (request.getSize() > -1) {
            searchSourceBuilder.size(request.getSize());
            searchSourceBuilder.from(request.getStart());
        }
        for (String aggregationName : this.aggregationList) {
            TermsAggregationBuilder agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)aggregationName).field(aggregationName);
            searchSourceBuilder.aggregation((AggregationBuilder)agg);
        }
        searchRequest.source(searchSourceBuilder);
        org.elasticsearch.action.search.SearchResponse searchResponse = null;
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error((Object)("Cannot search in index [" + index + "] index might not exist "), (Throwable)e);
            return new SearchResponse();
        }
        if (searchResponse == null) {
            log.warn((Object)"Empty searchResponse");
            return new SearchResponse();
        }
        RestStatus status = searchResponse.status();
        if (status.getStatus() != 200) {
            throw new Exception("Ann error occured when searcging index " + index + " " + status.getStatus());
        }
        SearchResponse response = this.buildSearchHits(searchResponse);
        HashMap<String, Facet> facetsMap = new HashMap<String, Facet>();
        for (String aggregationName : this.aggregationList) {
            Facet f = new Facet();
            f.setName(aggregationName);
            facetsMap.put(f.getName(), f);
            Terms termAgg = (Terms)searchResponse.getAggregations().get(aggregationName);
            for (Terms.Bucket entry : termAgg.getBuckets()) {
                String key = entry.getKeyAsString();
                long docCount = entry.getDocCount();
                Entry e = new Entry();
                e.setName(key);
                e.setCount(docCount);
                f.getEntries().add(e);
            }
        }
        response.setFacets(facetsMap);
        return response;
    }

    private SearchResponse buildSearchHits(org.elasticsearch.action.search.SearchResponse searchResponse) throws Exception {
        SearchResponse response = new SearchResponse();
        SearchHits hits = searchResponse.getHits();
        TotalHits totalHits = hits.getTotalHits();
        long numHits = totalHits.value;
        response.setCount(numHits);
        org.elasticsearch.search.SearchHit[] searchHits = hits.getHits();
        ArrayList<SearchHit> buildHits = new ArrayList<SearchHit>();
        ArrayList<String> ids = new ArrayList<String>();
        for (org.elasticsearch.search.SearchHit hit : searchHits) {
            String sourceAsString = hit.getSourceAsString();
            JsonParser parser = new JsonParser();
            JsonObject crunchifyObject = (JsonObject)parser.parse(sourceAsString);
            Map<String, Object> item = SearchDelegateImpl.toMap(crunchifyObject);
            String _id = hit.getId();
            if (_id == null) {
                throw new Exception("Indexed items don't have _id");
            }
            String sku = null;
            JsonElement _skuElement = crunchifyObject.get("sku");
            if (_skuElement != null) {
                sku = _skuElement.getAsString();
            }
            SearchHit h = new SearchHit(item, _id, sku);
            buildHits.add(h);
            ids.add(_id);
        }
        response.setIds(ids);
        response.setSearchHits(buildHits);
        return response;
    }
}

