/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.worker;

import com.shopizer.search.services.SearchHit;
import com.shopizer.search.services.SearchRequest;
import com.shopizer.search.services.SearchResponse;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.services.worker.DeleteObjectWorker;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.utils.CustomIndexConfiguration;
import com.shopizer.search.utils.SearchClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;

public class DeleteKeywordsImpl
implements DeleteObjectWorker {
    private static Logger log = Logger.getLogger(DeleteKeywordsImpl.class);
    private List<CustomIndexConfiguration> indexConfigurations = null;
    @Inject
    private SearchDelegate searchDelegate;

    @Override
    public void deleteObject(SearchClient client, String collection, String id, ExecutionContext context) throws Exception {
        Map indexData = (Map)context.getObject("indexData");
        if (indexData != null && !CollectionUtils.isEmpty(this.getIndexConfigurations())) {
            for (CustomIndexConfiguration indexConfiguration : this.getIndexConfigurations()) {
                String query = "{\"query\":{\"term\" : {\"_id_\" : \"" + id + "\" }}}";
                if (StringUtils.isBlank((CharSequence)indexConfiguration.getCollectionName())) {
                    return;
                }
                SearchRequest sr = new SearchRequest();
                sr.addCollection(indexConfiguration.getCollectionName());
                sr.setJson(query);
                SearchResponse r = this.searchDelegate.search(sr);
                if (r == null || CollectionUtils.isEmpty(r.getIds())) continue;
                ArrayList<String> ids = new ArrayList<String>();
                Collection<SearchHit> hits = r.getSearchHits();
                for (SearchHit hit : hits) {
                    ids.add(hit.getInternalId());
                }
                this.searchDelegate.bulkDeleteIndex(ids, indexConfiguration.getCollectionName());
            }
        }
    }

    @Override
    public void deleteObject(SearchClient client, final String collection, String id) throws Exception {
        if (this.searchDelegate.indexExist(collection)) {
            ActionListener<BulkByScrollResponse> listener = new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse deleteResponse) {
                }

                public void onFailure(Exception e) {
                    log.error((Object)("An issue occured while deleting document from index " + collection + " " + e.getMessage()));
                }
            };
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{collection});
            request.setQuery((QueryBuilder)new TermQueryBuilder("_id_", id));
            client.getClient().deleteByQueryAsync(request, RequestOptions.DEFAULT, (ActionListener)listener);
        }
    }

    public List<CustomIndexConfiguration> getIndexConfigurations() {
        return this.indexConfigurations;
    }

    public void setIndexConfigurations(List<CustomIndexConfiguration> indexConfigurations) {
        this.indexConfigurations = indexConfigurations;
    }
}

