/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.worker;

import com.shopizer.search.services.IndexKeywordRequest;
import com.shopizer.search.services.field.BooleanField;
import com.shopizer.search.services.field.DoubleField;
import com.shopizer.search.services.field.Field;
import com.shopizer.search.services.field.IntegerField;
import com.shopizer.search.services.field.ListField;
import com.shopizer.search.services.field.LongField;
import com.shopizer.search.services.field.StringField;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.services.worker.DeleteKeywordsImpl;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.services.worker.IndexWorker;
import com.shopizer.search.services.worker.Keyword;
import com.shopizer.search.utils.CustomIndexConfiguration;
import com.shopizer.search.utils.CustomIndexFieldConfiguration;
import com.shopizer.search.utils.DateUtil;
import com.shopizer.search.utils.FileUtil;
import com.shopizer.search.utils.SearchClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class KeywordIndexerImpl
implements IndexWorker {
    @Inject
    DeleteKeywordsImpl deleteKeywordsImpl;
    @Inject
    private SearchDelegate searchDelegate;
    private static Logger log = Logger.getLogger(KeywordIndexerImpl.class);
    private static boolean init = false;
    private Map<String, String> mappings = new ConcurrentHashMap<String, String>();
    private Map<String, String> settings = new ConcurrentHashMap<String, String>();
    private List<CustomIndexConfiguration> indexConfigurations = null;
    private static Map<String, CustomIndexConfiguration> indexConfigurationsMap = null;

    public List<CustomIndexConfiguration> getIndexConfigurations() {
        return this.indexConfigurations;
    }

    public void setIndexConfigurations(List<CustomIndexConfiguration> indexConfigurations) {
        this.indexConfigurations = indexConfigurations;
    }

    private String validateIndex(String index) throws Exception {
        Validate.notNull((Object)index, (String)"Index name must not be null", (Object[])new Object[0]);
        String keywordIndexPrefix = index.substring(index.indexOf("_"));
        String indexNameSubstitution = "keyword" + keywordIndexPrefix;
        String mapKey = indexNameSubstitution.substring(0, indexNameSubstitution.lastIndexOf("_"));
        if (!this.searchDelegate.indexExist(indexNameSubstitution)) {
            this.searchDelegate.createIndice(this.getMappings().get(mapKey), this.getSettings().get(mapKey), indexNameSubstitution);
        }
        return indexNameSubstitution;
    }

    private synchronized void init() {
        if (init) {
            return;
        }
        try {
            if (this.indexConfigurations != null) {
                Iterator<CustomIndexConfiguration> iterator = this.indexConfigurations.iterator();
                while (iterator.hasNext()) {
                    CustomIndexConfiguration o;
                    CustomIndexConfiguration ic = o = iterator.next();
                    String key = ic.getCreateOnIndexName();
                    if (indexConfigurationsMap == null) {
                        indexConfigurationsMap = new HashMap<String, CustomIndexConfiguration>();
                    }
                    if (StringUtils.isBlank((CharSequence)key)) {
                        log.error((Object)"*********************************************");
                        log.error((Object)"Require property createOnIndexName in keyword indexer");
                        log.error((Object)"*********************************************");
                        continue;
                    }
                    indexConfigurationsMap.put(key, ic);
                    String mappingFile = null;
                    String settingsFile = null;
                    if (!StringUtils.isBlank((CharSequence)ic.getMappingFileName())) {
                        mappingFile = ic.getMappingFileName();
                    }
                    if (!StringUtils.isBlank((CharSequence)ic.getSettingsFileName())) {
                        settingsFile = ic.getSettingsFileName();
                    }
                    if (mappingFile == null && settingsFile == null) continue;
                    String metadata = null;
                    String settingsdata = null;
                    try {
                        if (mappingFile != null) {
                            metadata = FileUtil.readFileAsString(mappingFile);
                            this.mappings.put(ic.getIndexName(), metadata);
                        }
                        if (settingsFile == null) continue;
                        settingsdata = FileUtil.readFileAsString(settingsFile);
                        this.settings.put(ic.getIndexName(), settingsdata);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        log.error((Object)"*********************************************");
                        log.error((Object)e);
                        log.error((Object)"*********************************************");
                        init = false;
                    }
                }
            }
            init = true;
        }
        catch (Exception e) {
            log.error((Object)"*********************************************");
            log.error((Object)e);
            log.error((Object)"*********************************************");
        }
    }

    @Override
    public void execute(SearchClient client, String json, String collection, String id, ExecutionContext context) throws Exception {
        if (!init) {
            this.init();
        }
        try {
            int indexOf = collection.lastIndexOf("_");
            String indexName = collection.substring(0, indexOf);
            indexName = indexName + "_*";
            String index = this.validateIndex(collection);
            if (indexConfigurationsMap != null && indexConfigurationsMap.containsKey(indexName)) {
                Map indexData = (Map)context.getObject("indexData");
                CustomIndexConfiguration conf = indexConfigurationsMap.get(indexName);
                List<CustomIndexFieldConfiguration> fields = conf.getFields();
                if (fields != null) {
                    ArrayList<Keyword> k = new ArrayList<Keyword>();
                    for (CustomIndexFieldConfiguration o : fields) {
                        Keyword word;
                        String fieldType;
                        CustomIndexFieldConfiguration cifc = o;
                        String fieldName = cifc.getFieldName();
                        if (fieldName.trim().toLowerCase().equals("_id_") || StringUtils.isBlank((CharSequence)(fieldType = cifc.getFieldType()))) continue;
                        if (fieldType.equals("List")) {
                            try {
                                List keyWords = (List)indexData.get(fieldName);
                                if (keyWords == null) continue;
                                for (String keyword : keyWords) {
                                    word = new Keyword();
                                    word.setKeyword(keyword);
                                    word.setOriginal(keyword);
                                    k.add(word);
                                }
                                continue;
                            }
                            catch (Exception e) {
                                String keyword = (String)indexData.get(fieldName);
                                if (keyword == null) continue;
                                Keyword word2 = new Keyword();
                                word2.setKeyword(keyword);
                                word2.setOriginal(keyword);
                                k.add(word2);
                                continue;
                            }
                        }
                        String keyword = (String)indexData.get(fieldName);
                        String[] splitted = keyword.split(" ");
                        if (keyword == null) continue;
                        if (k == null) {
                            k = new ArrayList();
                        }
                        for (int i = 0; i < splitted.length; ++i) {
                            word = new Keyword();
                            word.setKeyword(splitted[i]);
                            word.setOriginal(keyword);
                            k.add(word);
                        }
                    }
                    if (!CollectionUtils.isEmpty(k)) {
                        ArrayList<IndexKeywordRequest> bulks = new ArrayList<IndexKeywordRequest>();
                        for (Keyword o : k) {
                            IndexKeywordRequest kr = new IndexKeywordRequest();
                            String value = o.getKeyword();
                            String original = o.getOriginal();
                            if (StringUtils.isBlank((CharSequence)value)) continue;
                            String _id = (String)indexData.get("id");
                            kr.setId(_id);
                            kr.setOriginal(original);
                            kr.setKeyword(value.toLowerCase().trim());
                            if (conf.getFilters() != null && conf.getFilters().size() > 0) {
                                Iterator<CustomIndexFieldConfiguration> iterator = conf.getFilters().iterator();
                                while (iterator.hasNext()) {
                                    Object ooo;
                                    CustomIndexFieldConfiguration oo;
                                    CustomIndexFieldConfiguration filter = oo = iterator.next();
                                    String fieldName = filter.getFieldName();
                                    String fieldType = filter.getFieldType();
                                    Field f = null;
                                    if (fieldType.equals("List")) {
                                        ooo = (List)indexData.get(fieldName);
                                        f = new ListField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Boolean")) {
                                        String s = (String)indexData.get(fieldName);
                                        Boolean ooo2 = new Boolean(s);
                                        f = new BooleanField();
                                        f.setValue(ooo2);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Integer")) {
                                        ooo = (Integer)indexData.get(fieldName);
                                        f = new IntegerField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Long")) {
                                        ooo = (Long)indexData.get(fieldName);
                                        f = new LongField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Double")) {
                                        ooo = (Double)indexData.get(fieldName);
                                        f = new DoubleField();
                                        f.setValue(ooo);
                                        f.setName(fieldName);
                                        kr.getFilters().add(f);
                                        continue;
                                    }
                                    if (fieldType.equals("Date")) {
                                        String d = (String)indexData.get(fieldName);
                                        try {
                                            Date dt = DateUtil.formatDate(d);
                                            f = new DoubleField();
                                            f.setValue(dt);
                                            f.setName(fieldName);
                                            kr.getFilters().add(f);
                                        }
                                        catch (Exception e) {
                                            log.error((Object)("Invalid date format " + d));
                                        }
                                        continue;
                                    }
                                    ooo = (String)indexData.get(fieldName);
                                    f = new StringField();
                                    f.setValue(((String)ooo).toLowerCase());
                                    f.setName(fieldName);
                                    kr.getFilters().add(f);
                                }
                            }
                            bulks.add(kr);
                        }
                        this.deleteKeywordsImpl.deleteObject(client, index, id);
                        this.searchDelegate.bulkIndexKeywords(bulks, index);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot index keywords, maybe a timing ussue for no shards available", (Throwable)e);
        }
    }

    @Override
    public void init(SearchClient client) {
        if (!init) {
            this.init();
        }
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }
}

