/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.shopizer.search.services.GetResponse;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.services.worker.IndexWorker;
import com.shopizer.search.utils.FileUtil;
import com.shopizer.search.utils.IndexConfiguration;
import com.shopizer.search.utils.SearchClient;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.log4j.Logger;

public class ObjectIndexerImpl
implements IndexWorker {
    private static boolean init = false;
    @Inject
    private SearchDelegate searchDelegate;
    private List<IndexConfiguration> indexConfigurations;
    private Map<String, String> mappings = new ConcurrentHashMap<String, String>();
    private Map<String, String> settings = new ConcurrentHashMap<String, String>();
    private static Logger log = Logger.getLogger(ObjectIndexerImpl.class);

    public List<IndexConfiguration> getIndexConfigurations() {
        return this.indexConfigurations;
    }

    public void setIndexConfigurations(List<IndexConfiguration> indexConfigurations) {
        this.indexConfigurations = indexConfigurations;
    }

    @Override
    public synchronized void init(SearchClient client) {
        if (init) {
            return;
        }
        if (this.getIndexConfigurations() != null && this.getIndexConfigurations().size() > 0) {
            Iterator<IndexConfiguration> iterator = this.indexConfigurations.iterator();
            while (iterator.hasNext()) {
                IndexConfiguration o;
                IndexConfiguration config = o = iterator.next();
                String mappingFile = null;
                String settingsFile = null;
                if (!StringUtils.isBlank((CharSequence)config.getMappingFileName())) {
                    mappingFile = config.getMappingFileName();
                }
                if (!StringUtils.isBlank((CharSequence)config.getSettingsFileName())) {
                    settingsFile = config.getSettingsFileName();
                }
                if (mappingFile == null && settingsFile == null) continue;
                String metadata = null;
                String settingsdata = null;
                try {
                    if (mappingFile != null) {
                        metadata = FileUtil.readFileAsString(mappingFile);
                        this.mappings.put(config.getIndexName(), metadata);
                    }
                    if (settingsFile == null) continue;
                    settingsdata = FileUtil.readFileAsString(settingsFile);
                    this.settings.put(config.getIndexName(), settingsdata);
                }
                catch (Exception e) {
                    log.error((Object)e);
                    log.error((Object)"*********************************************");
                    log.error((Object)e);
                    log.error((Object)"*********************************************");
                    init = false;
                }
            }
            init = true;
        }
    }

    private void validateIndex(String index) throws Exception {
        Validate.notNull((Object)index, (String)"Index name must not be null", (Object[])new Object[0]);
        String indexNameStripped = index.substring(0, index.lastIndexOf("_"));
        if (!this.searchDelegate.indexExist(index)) {
            this.searchDelegate.createIndice(this.getMappings().get(indexNameStripped), this.getSettings().get(indexNameStripped), index);
        }
    }

    @Override
    public void execute(SearchClient client, String json, String index, String id, ExecutionContext context) throws Exception {
        try {
            if (!init) {
                this.init(client);
            }
            this.validateIndex(index);
            Map indexData = (Map)context.getObject("indexData");
            if (indexData == null) {
                ObjectMapper mapper = new ObjectMapper();
                indexData = (Map)mapper.readValue(json, Map.class);
            }
            if (context == null) {
                context = new ExecutionContext();
            }
            context.setObject("indexData", indexData);
            GetResponse r = this.searchDelegate.getObject(index, id);
            if (r != null) {
                this.searchDelegate.delete(index, id);
            }
            this.searchDelegate.index(json, index, id);
        }
        catch (Exception e) {
            log.error((Object)"Exception while indexing a product, maybe a timing ussue for no shards available", (Throwable)e);
        }
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }
}

