/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.utils;

import com.shopizer.search.utils.ServerConfiguration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.log4j.Logger;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class SearchClient {
    private static Logger log = Logger.getLogger(SearchClient.class);
    private RestHighLevelClient client = null;
    private boolean init = false;
    private ServerConfiguration serverConfiguration = null;
    private String authenticationHeader = null;

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    public RestHighLevelClient getClient() {
        if (!this.init) {
            this.initClient();
        }
        return this.client;
    }

    private synchronized void initClient() {
        if (this.client == null) {
            try {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getServerConfiguration().getElasticSearchUser(), this.getServerConfiguration().getElasticSearchPassword()));
                String clusterHost = this.getServerConfiguration().getClusterHost();
                int clusterPort = this.getServerConfiguration().getClusterPort();
                String protocole = this.getServerConfiguration().getProtocole();
                log.debug((Object)("Elastic search client connecting to " + protocole + "://" + clusterHost + ":" + clusterPort));
                RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(clusterHost, clusterPort, protocole)});
                if (this.getServerConfiguration().getSecurityEnabled() != null && this.getServerConfiguration().getSecurityEnabled().booleanValue()) {
                    builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                        final /* synthetic */ CredentialsProvider val$credentialsProvider;
                        {
                            this.val$credentialsProvider = credentialsProvider;
                        }

                        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                            return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                        }
                    });
                }
                this.client = new RestHighLevelClient(builder);
                this.init = true;
                log.debug((Object)"****** ES client ready ********");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAuthenticationHeader() {
        return this.authenticationHeader;
    }

    public void setAuthenticationHeader(String authenticationHeader) {
        this.authenticationHeader = authenticationHeader;
    }
}

