/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopizer.search.services.Entry;
import com.shopizer.search.services.Facet;
import com.shopizer.search.services.GetResponse;
import com.shopizer.search.services.IndexKeywordRequest;
import com.shopizer.search.services.SearchHit;
import com.shopizer.search.services.SearchRequest;
import com.shopizer.search.services.SearchResponse;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.utils.SearchClient;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Bulk;
import io.searchbox.core.Delete;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.TermsAggregation;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.mapping.PutMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;

public class SearchDelegateImpl
implements SearchDelegate {
    private List<String> aggregationList;
    private SearchClient searchClient = null;
    private static Logger log = Logger.getLogger(SearchDelegateImpl.class);

    public List<String> getAggregationList() {
        return this.aggregationList;
    }

    public void setAggregationList(List<String> aggregationList) {
        this.aggregationList = aggregationList;
    }

    public SearchClient getSearchClient() {
        return this.searchClient;
    }

    public void setSearchClient(SearchClient searchClient) {
        this.searchClient = searchClient;
    }

    private Object readNode(JsonElement jsonElement) throws Exception {
        HashMap container = null;
        if (jsonElement.isJsonObject()) {
            Set ens = ((JsonObject)jsonElement).entrySet();
            if (ens != null) {
                for (Map.Entry en : ens) {
                    if (container == null) {
                        container = new HashMap();
                    }
                    ((Map)container).put(en.getKey(), this.readNode((JsonElement)en.getValue()));
                }
            }
        } else if (jsonElement.isJsonArray()) {
            JsonArray jarr = jsonElement.getAsJsonArray();
            container = new ArrayList();
            for (JsonElement je : jarr) {
                ((List)((Object)container)).add(this.readNode(je));
            }
        } else if (!jsonElement.isJsonNull() && jsonElement.isJsonPrimitive()) {
            container = jsonElement.getAsString();
        }
        return container;
    }

    private Map<String, Object> getResults(JsonObject jsonObject, String path) throws Exception {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        JsonElement jsonElement = jsonObject.get(path);
        Set ens = ((JsonObject)jsonElement).entrySet();
        if (ens != null) {
            for (Map.Entry en : ens) {
                fields.put((String)en.getKey(), this.readNode((JsonElement)en.getValue()));
            }
        }
        return fields;
    }

    @Override
    public boolean indexExist(String indexName) throws Exception {
        JestClient client = this.searchClient.getClient();
        IndicesExists.Builder builder = new IndicesExists.Builder(indexName);
        if (!StringUtils.isBlank((CharSequence)this.searchClient.getAuthenticationHeader())) {
            builder.setHeader("Authorization", (Object)this.searchClient.getAuthenticationHeader());
        }
        IndicesExists action = builder.build();
        JestResult result = client.execute((Action)action);
        return result.isSucceeded();
    }

    @Override
    public void createIndice(String mapping, String settings, String index, String object) throws Exception {
        JestClient client = this.searchClient.getClient();
        CreateIndex.Builder createIndex = new CreateIndex.Builder(index);
        if (!StringUtils.isEmpty((CharSequence)settings)) {
            createIndex.settings((Object)Settings.builder().loadFromSource(settings, XContentType.JSON).build().getAsMap());
        }
        client.execute((Action)createIndex.build());
        PutMapping.Builder putMapping = new PutMapping.Builder(index, object, (Object)mapping);
        JestResult result = client.execute((Action)putMapping.build());
        if (result != null && !StringUtils.isBlank((CharSequence)result.getErrorMessage())) {
            log.error((Object)("An error occured while creating an index " + result.getErrorMessage()));
        }
    }

    @Override
    public void index(String json, String collection, String object, String id) throws Exception {
        Index index;
        JestClient client = this.searchClient.getClient();
        JestResult result = client.execute((Action)(index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)json).index(collection)).type(object)).id(id)).build()));
        if (result != null && !StringUtils.isBlank((CharSequence)result.getErrorMessage())) {
            log.error((Object)("An error occured while indexing a document " + json + " " + result.getErrorMessage()));
        }
    }

    @Override
    public void delete(String collection, String object, String id) throws Exception {
        Delete builder;
        JestClient client;
        JestResult result;
        if (this.indexExist(collection) && (result = (client = this.searchClient.getClient()).execute((Action)(builder = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(collection)).type(object)).build()))) != null && !result.isSucceeded() && !StringUtils.isBlank((CharSequence)result.getErrorMessage())) {
            log.error((Object)("Cannot delete from " + collection + " with id " + id));
        }
    }

    @Override
    public void bulkDeleteIndex(Collection<String> ids, String collection, String object) throws Exception {
        if (this.indexExist(collection)) {
            JestClient client = this.searchClient.getClient();
            if (ids != null && ids.size() > 0) {
                Bulk.Builder bulk = new Bulk.Builder().defaultIndex(collection);
                for (String s : ids) {
                    bulk.defaultType(object).addAction((BulkableAction)((Delete.Builder)((Delete.Builder)new Delete.Builder(s).index(collection)).type(object)).build());
                }
                JestResult results = client.execute((Action)bulk.build());
                if (!results.isSucceeded()) {
                    log.error((Object)("ES response has failures " + results.getErrorMessage()));
                }
            }
        }
    }

    @Override
    public void bulkIndexKeywords(Collection<IndexKeywordRequest> bulks, String collection, String object) throws Exception {
        JestClient client = this.searchClient.getClient();
        Bulk.Builder bulk = new Bulk.Builder().defaultIndex(collection).defaultType(object);
        for (IndexKeywordRequest key : bulks) {
            String id = key.getKey();
            if (id.length() > 25) {
                id = id.substring(0, 25);
            }
            id = id.trim().toLowerCase();
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{\"_id_\":").append("\"").append(key.getId()).append("\",").append("\"keyword\":").append("\"").append(key.getKey()).append("\"}");
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)jsonBuilder.toString()).index(collection)).type(object)).id(id)).build();
            bulk.addAction((BulkableAction)index);
        }
        log.debug((Object)("Adding to collection " + collection));
        JestResult results = client.execute((Action)bulk.build());
        if (!results.isSucceeded()) {
            log.error((Object)("ES response has failures " + results.getErrorMessage()));
        }
    }

    @Override
    public GetResponse getObject(String collection, String object, String id) throws Exception {
        JestClient client = this.searchClient.getClient();
        Get get = ((Get.Builder)new Get.Builder(collection, id).type(object)).build();
        JestResult result = client.execute((Action)get);
        GetResponse response = null;
        if (result != null && StringUtils.isBlank((CharSequence)result.getErrorMessage())) {
            JsonObject jsonObject = result.getJsonObject();
            Map<String, Object> fields = this.getResults(jsonObject, "_source");
            response = new GetResponse(fields);
            response.setObjectJson(result.getJsonString());
        } else {
            log.error((Object)("Error wile performing a get method " + result.getErrorMessage()));
        }
        return response;
    }

    @Override
    public SearchResponse search(SearchRequest request) throws Exception {
        SearchResult result;
        JestClient client = this.searchClient.getClient();
        SearchResponse response = new SearchResponse();
        Search.Builder search = new Search.Builder(request.getJson());
        for (String index : request.getCollections()) {
            search.addIndex(index);
        }
        if (request.getSize() > -1) {
            search.setParameter("size", (Object)request.getSize());
        }
        if ((result = (SearchResult)client.execute((Action)search.build())) == null) {
            throw new Exception("Search result is null");
        }
        if (!result.isSucceeded() && !StringUtils.isBlank((CharSequence)result.getErrorMessage())) {
            log.error((Object)("An error occured while searching " + result.getErrorMessage()));
            return response;
        }
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        ArrayList<String> ids = new ArrayList<String>();
        JsonArray responseHits = result.getJsonObject().getAsJsonObject("hits").getAsJsonArray("hits");
        response.setCount(responseHits.size());
        for (JsonElement element : responseHits) {
            JsonObject jsonObject = element.getAsJsonObject();
            Map<String, Object> item = this.getResults(jsonObject, "_source");
            JsonElement _idElement = jsonObject.get("_id");
            String _id = _idElement.getAsString();
            SearchHit hit = new SearchHit(item, _id);
            hits.add(hit);
            ids.add((String)item.get("id"));
        }
        response.setIds(ids);
        response.setSearchHits(hits);
        TermsAggregation terms = null;
        HashMap<String, Facet> facetsMap = new HashMap<String, Facet>();
        if (result.getAggregations() != null) {
            if (CollectionUtils.isNotEmpty(this.aggregationList)) {
                for (String agg : this.aggregationList) {
                    terms = result.getAggregations().getTermsAggregation(agg);
                    if (terms == null) continue;
                    List entries = terms.getBuckets();
                    Facet f = new Facet();
                    f.setName(terms.getName());
                    ArrayList<Entry> facetEntries = new ArrayList<Entry>();
                    for (TermsAggregation.Entry ent : entries) {
                        Entry entry = new Entry();
                        entry.setName(ent.getKey());
                        entry.setCount(ent.getCount());
                        facetEntries.add(entry);
                    }
                    f.setEntries(facetEntries);
                    facetsMap.put(f.getName(), f);
                }
            }
            response.setFacets(facetsMap);
        }
        response.setSearchHits(hits);
        return response;
    }

    @Override
    public Set<String> searchAutocomplete(String collection, String json, int size) throws Exception {
        JestClient client = this.searchClient.getClient();
        Search.Builder search = new Search.Builder(json);
        search.addIndex(collection);
        SearchResult result = (SearchResult)client.execute((Action)search.build());
        if (result == null) {
            throw new Exception("Search result is null");
        }
        if (!result.isSucceeded() && !StringUtils.isBlank((CharSequence)result.getErrorMessage())) {
            log.error((Object)("An error occured while searching " + result.getErrorMessage()));
            return null;
        }
        JsonArray responseHits = result.getJsonObject().getAsJsonObject("hits").getAsJsonArray("hits");
        HashSet<String> keywords = new HashSet<String>();
        for (JsonElement element : responseHits) {
            JsonObject jsonObject = element.getAsJsonObject();
            Map<String, Object> item = this.getResults(jsonObject, "_source");
            keywords.add((String)item.get("keyword"));
        }
        return keywords;
    }
}

