/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.services.worker;

import com.shopizer.search.services.SearchHit;
import com.shopizer.search.services.SearchRequest;
import com.shopizer.search.services.SearchResponse;
import com.shopizer.search.services.impl.SearchDelegate;
import com.shopizer.search.services.worker.DeleteObjectWorker;
import com.shopizer.search.services.worker.ExecutionContext;
import com.shopizer.search.utils.CustomIndexConfiguration;
import com.shopizer.search.utils.SearchClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DeleteKeywordsImpl
implements DeleteObjectWorker {
    private List<CustomIndexConfiguration> indexConfigurations = null;
    @Inject
    private SearchDelegate searchDelegate;

    @Override
    public void deleteObject(SearchClient client, String collection, String object, String id, ExecutionContext context) throws Exception {
        Map indexData = (Map)context.getObject("indexData");
        if (indexData != null && !CollectionUtils.isEmpty(this.getIndexConfigurations())) {
            for (CustomIndexConfiguration indexConfiguration : this.getIndexConfigurations()) {
                String query = "{\"query\":{\"term\" : {\"_id_\" : \"" + id + "\" }}}";
                if (StringUtils.isBlank((CharSequence)indexConfiguration.getCollectionName())) {
                    return;
                }
                SearchRequest sr = new SearchRequest();
                sr.addCollection(indexConfiguration.getCollectionName());
                sr.setJson(query);
                SearchResponse r = this.searchDelegate.search(sr);
                if (r == null || CollectionUtils.isEmpty(r.getIds())) continue;
                ArrayList<String> ids = new ArrayList<String>();
                Collection<SearchHit> hits = r.getSearchHits();
                for (SearchHit hit : hits) {
                    ids.add(hit.getInternalId());
                }
                this.searchDelegate.bulkDeleteIndex(ids, indexConfiguration.getCollectionName(), indexConfiguration.getIndexName());
            }
        }
    }

    @Override
    public void deleteObject(SearchClient client, String collection, String object, String id) throws Exception {
        if (this.searchDelegate.indexExist(collection)) {
            String query = "{\"query\":{\"term\" : {\"_id_\" : \"" + id + "\" }}}";
            SearchRequest sr = new SearchRequest();
            sr.addCollection(collection);
            sr.setJson(query);
            SearchResponse r = this.searchDelegate.search(sr);
            if (r != null) {
                Collection<String> ids = r.getIds();
                this.searchDelegate.bulkDeleteIndex(ids, collection, object);
            }
        }
    }

    public List<CustomIndexConfiguration> getIndexConfigurations() {
        return this.indexConfigurations;
    }

    public void setIndexConfigurations(List<CustomIndexConfiguration> indexConfigurations) {
        this.indexConfigurations = indexConfigurations;
    }
}

