/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shz.core.AccessibleHelp;
import shz.core.NullHelp;
import shz.core.ToMap;
import shz.core.cl.ClassLoaderHelp;
import shz.core.orm.ClassInfo;
import shz.core.orm.OrmService;
import shz.core.orm.entity.SysDs;
import shz.core.orm.enums.Condition;
import shz.core.orm.enums.DataType;
import shz.core.orm.param.OrmMapConsumer;
import shz.core.orm.param.OrmMapFilter;
import shz.core.orm.param.OrmMapping;
import shz.core.st.tst.LTST;
import shz.core.structure.limiter.Limiter;
import shz.core.type.TypeHelp;
import shz.jdbc.JdbcServiceHelper;

public class JdbcService
extends JdbcServiceHelper {
    private static final JdbcService NULL = new JdbcService();
    private static final Map<String, JdbcService> DS_SERVICE_CACHE = new ConcurrentHashMap<String, JdbcService>();
    protected static final LTST<Map<String, String>> SQL_COLUMN_MAPPING_CACHE = LTST.of();

    protected final OrmService service(String dsName) {
        JdbcService service = DS_SERVICE_CACHE.computeIfAbsent(dsName, k -> {
            try {
                SysDs ds = (SysDs)this.selectOne(SysDs.class, true, null, this.whereSql(this.nonNullClassInfo(SysDs.class), "name", dsName, Condition.EQ, Boolean.FALSE));
                return ds == null ? NULL : this.createService(ds);
            }
            catch (Exception e) {
                return NULL;
            }
        });
        return service == NULL ? null : service;
    }

    protected JdbcService createService(SysDs ds) {
        JdbcService service = (JdbcService)((Object)AccessibleHelp.newInstance((Class)ClassLoaderHelp.load((String)ds.getServiceClassName(), (boolean)false)));
        NullHelp.requireNonNull((Object)((Object)service), (String)"\u5b9e\u4f8b\u5316JdbcService\u7c7b:%s\u5931\u8d25,\u6570\u636e\u6e90\u540d\u79f0:%s", (Object[])new Object[]{ds.getServiceClassName(), ds.getName()});
        service.setJdbcTemplate(ds.getDriverClassName(), ds.getUrl(), ds.getUsername(), ds.getPassword());
        return service;
    }

    public final void removeService(String dsName) {
        DS_SERVICE_CACHE.remove(dsName);
    }

    public final void query(OrmMapping mapping, Type type, Limiter limiter, OrmMapFilter mapFilter, OrmMapConsumer mapConsumer, int fetchSize, String sql, Object ... params) {
        NullHelp.requireNon((mapFilter == null && mapConsumer == null ? 1 : 0) != 0);
        this.jdbcTemplate.execute(sql, ps -> {
            if (fetchSize != Integer.MAX_VALUE) {
                ps.setFetchSize(fetchSize == 0 ? 3000 : (fetchSize < 0 ? 6000 : fetchSize));
            }
            this.setPs(ps, params);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int count = metaData.getColumnCount();
            int capacity = (int)Math.ceil((float)count / 0.75f);
            Map<String, String> columnMapping = this.columnMapping(mapping, type, metaData, sql);
            while (rs.next() && (limiter == null || !limiter.isLimit())) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(capacity, 1.0f);
                for (Map.Entry<String, String> entry : columnMapping.entrySet()) {
                    map.put(entry.getValue(), this.sqlHandler.valueMap(rs.getObject(entry.getKey())));
                }
                if (mapFilter != null && !mapFilter.test(map)) continue;
                if (mapConsumer == null) {
                    if (limiter == null || !limiter.isLimitAfter()) continue;
                    break;
                }
                mapConsumer.accept(map);
            }
            return null;
        });
    }

    protected Map<String, String> columnMapping(OrmMapping mapping, Type type, ResultSetMetaData metaData, String sql) throws SQLException {
        char[] chars = sql.toCharArray();
        Map columnMapping = (Map)SQL_COLUMN_MAPPING_CACHE.get(chars);
        if (columnMapping != null) {
            return columnMapping;
        }
        columnMapping = ToMap.get((int)metaData.getColumnCount()).build();
        DataType dataType = this.dataType(type);
        if (dataType == DataType.MAP || dataType == DataType.LIST || dataType == DataType.ARRAY || dataType == DataType.COMMON) {
            this.simpleColumnMapping(mapping, metaData, columnMapping);
        } else if (dataType == DataType.DEFAULT) {
            this.defaultColumnMapping(mapping, type, metaData, columnMapping);
        } else {
            this.nestedColumMapping(mapping, type, metaData, columnMapping);
        }
        SQL_COLUMN_MAPPING_CACHE.put(chars, (Object)columnMapping);
        return columnMapping;
    }

    private void simpleColumnMapping(OrmMapping mapping, ResultSetMetaData metaData, Map<String, String> columnMapping) throws SQLException {
        int count = metaData.getColumnCount();
        if (mapping == null) {
            for (int i = 0; i < count; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                columnMapping.put(columnLabel, columnLabel);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                columnMapping.put(columnLabel, (String)NullHelp.nullOrElse((Object)mapping.apply((Object)columnLabel), (Object)columnLabel));
            }
        }
    }

    private void defaultColumnMapping(OrmMapping mapping, Type type, ResultSetMetaData metaData, Map<String, String> columnMapping) throws SQLException {
        Class cls = TypeHelp.toClass((Type)type);
        List fields = AccessibleHelp.fields((Class)cls);
        if (fields.isEmpty()) {
            this.simpleColumnMapping(mapping, metaData, columnMapping);
            return;
        }
        ClassInfo classInfo = this.classInfo(cls);
        int count = metaData.getColumnCount();
        if (mapping == null) {
            for (int i = 0; i < count; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                columnMapping.put(columnLabel, this.defaultColumnMapping(classInfo, fields, columnLabel));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                columnMapping.put(columnLabel, this.defaultColumnMapping(classInfo, fields, (String)NullHelp.nullOrElse((Object)mapping.apply((Object)columnLabel), (Object)columnLabel)));
            }
        }
    }

    private String defaultColumnMapping(ClassInfo classInfo, List<Field> fields, String column) {
        for (Field field : fields) {
            if ((classInfo == null || !column.equals(classInfo.toColumnName(field.getName()))) && !this.sqlHandler.aliasToField(column).equals(field.getName()) && !column.equals(this.sqlHandler.humpToUnderline(field.getName()))) continue;
            return field.getName();
        }
        return null;
    }

    private void nestedColumMapping(OrmMapping mapping, Type type, ResultSetMetaData metaData, Map<String, String> columnMapping) throws SQLException {
        Class cls = TypeHelp.toClass((Type)type);
        List fields = AccessibleHelp.fields((Class)cls);
        if (fields.isEmpty()) {
            this.simpleColumnMapping(mapping, metaData, columnMapping);
            return;
        }
        ClassInfo classInfo = this.classInfo(cls);
        Map fieldTypeMap = TypeHelp.fieldType((Type)type);
        int count = metaData.getColumnCount();
        if (mapping == null) {
            for (int i = 0; i < count; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                columnMapping.put(columnLabel, this.nestedColumMapping(classInfo, fieldTypeMap, fields, columnLabel, ""));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                String columnLabel = metaData.getColumnLabel(i + 1);
                columnMapping.put(columnLabel, this.nestedColumMapping(classInfo, fieldTypeMap, fields, (String)NullHelp.nullOrElse((Object)mapping.apply((Object)columnLabel), (Object)columnLabel), ""));
            }
        }
    }

    private String nestedColumMapping(ClassInfo classInfo, Map<Field, Type> fieldTypeMap, List<Field> fields, String column, String mapField) {
        if (fields.isEmpty()) {
            return null;
        }
        for (Field field : fields) {
            String key;
            if (classInfo != null && column.equals(classInfo.toColumnName(field.getName()))) {
                return field.getName();
            }
            String alias = this.sqlHandler.aliasToField(column);
            if (alias.equals(field.getName()) || alias.equals(mapField + field.getName())) {
                return alias;
            }
            if (column.equals(this.sqlHandler.humpToUnderline(field.getName()))) {
                return field.getName();
            }
            Class fCls = TypeHelp.fieldClass((Field)field, fieldTypeMap);
            if (Map.class.isAssignableFrom(fCls) || TypeHelp.likeCommon((Class)fCls)) continue;
            if (Collection.class.isAssignableFrom(fCls) || fCls.isArray()) {
                Type[] types = TypeHelp.getActualTypeArguments((Type)TypeHelp.fieldType((Field)field, fieldTypeMap));
                if (types == null || types.length != 1) continue;
                Class cls = TypeHelp.toClass((Type)types[0]);
                if (TypeHelp.likeCommon((Class)cls)) {
                    if (!alias.equals(mapField + field.getName() + ".x") && !alias.equals(mapField + field.getName() + ".X")) continue;
                    return alias;
                }
                if (!TypeHelp.likeModel((Class)cls) || (key = this.nestedColumMapping(this.classInfo(cls), fieldTypeMap, AccessibleHelp.fields((Class)cls), column, mapField + field.getName() + ".")) == null) continue;
                return key;
            }
            key = this.nestedColumMapping(this.classInfo(fCls), fieldTypeMap, AccessibleHelp.fields((Class)fCls), column, mapField + field.getName() + ".");
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

