/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc;

import com.alibaba.druid.pool.DruidDataSource;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import shz.core.AccessibleHelp;
import shz.core.Container;
import shz.core.NullHelp;
import shz.core.PRException;
import shz.core.orm.OrmService;
import shz.core.orm.annotation.Column;
import shz.core.orm.enums.DataType;
import shz.core.orm.sql.handler.SqlHandler;
import shz.core.type.TypeHelp;
import shz.jdbc.handler.MysqlSqlHandler;
import shz.jdbc.handler.OracleSqlHandler;
import shz.jdbc.handler.PostgresSqlHandler;
import shz.jdbc.model.Table;

abstract class JdbcServiceHelper
extends OrmService {
    protected PlatformTransactionManager transactionManager;
    protected JdbcTemplate jdbcTemplate;
    private static final Map<DataSource, SqlHandler> SQL_HANDLERS = new ConcurrentHashMap<DataSource, SqlHandler>(4);
    private static final Map<Type, DataType> DATA_TYPE_CACHE = new HashMap<Type, DataType>(128);

    JdbcServiceHelper() {
    }

    public final PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public final void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public final void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        Objects.requireNonNull(jdbcTemplate);
        this.jdbcTemplate = jdbcTemplate;
        this.sqlHandler = this.sqlHandler(jdbcTemplate.getDataSource());
    }

    public final void setJdbcTemplate(String driverClassName, String url, String username, String password) {
        this.setJdbcTemplate(this.defaultJdbcTemplate(driverClassName, url, username, password));
    }

    protected JdbcTemplate defaultJdbcTemplate(String driverClassName, String url, String username, String password) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        DruidDataSource dataSource = new DruidDataSource();
        jdbcTemplate.setDataSource((DataSource)dataSource);
        dataSource.setDriverClassName(driverClassName);
        dataSource.setUrl(url);
        dataSource.setUsername(username);
        dataSource.setPassword(password);
        dataSource.setInitialSize(1);
        dataSource.setMaxActive(64);
        dataSource.setMinIdle(2);
        dataSource.setMaxWait(60000L);
        dataSource.setPoolPreparedStatements(false);
        dataSource.setMaxOpenPreparedStatements(-1);
        dataSource.setValidationQuery("SELECT 1 FROM DUAL");
        dataSource.setTestOnBorrow(true);
        dataSource.setTestOnReturn(false);
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setMinEvictableIdleTimeMillis(300000L);
        Properties connectProperties = new Properties();
        connectProperties.setProperty("druid.stat.mergeSql", "true");
        connectProperties.setProperty("druid.stat.slowSqlMillis", "5000");
        dataSource.setConnectProperties(connectProperties);
        return jdbcTemplate;
    }

    protected SqlHandler sqlHandler(DataSource dataSource) {
        return SQL_HANDLERS.computeIfAbsent(dataSource, k -> {
            String productName;
            Connection conn = null;
            try {
                conn = dataSource.getConnection();
                productName = conn.getMetaData().getDatabaseProductName();
            }
            catch (SQLException e) {
                throw PRException.of((Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            NullHelp.requireNonBlank((Object)productName);
            switch (productName) {
                case "MySQL": {
                    return (SqlHandler)Container.get(MysqlSqlHandler.class, MysqlSqlHandler::new);
                }
                case "Oracle": {
                    return (SqlHandler)Container.get(OracleSqlHandler.class, OracleSqlHandler::new);
                }
                case "PostgreSQL": {
                    return (SqlHandler)Container.get(PostgresSqlHandler.class, PostgresSqlHandler::new);
                }
            }
            throw new UnsupportedOperationException();
        });
    }

    protected final String humpToUnderline(String name) {
        return this.sqlHandler.humpToUnderline(name);
    }

    protected final DataType dataType(Type type) {
        Class cls = TypeHelp.toClass((Type)type);
        if (cls == null || Map.class.isAssignableFrom(cls)) {
            return DataType.MAP;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return DataType.LIST;
        }
        if (cls.isArray()) {
            return DataType.ARRAY;
        }
        if (TypeHelp.likeCommon((Class)cls)) {
            return DataType.COMMON;
        }
        return DATA_TYPE_CACHE.computeIfAbsent(type, k -> {
            boolean nested = false;
            for (Field f : AccessibleHelp.fields((Class)TypeHelp.toClass((Type)k))) {
                Column column = f.getAnnotation(Column.class);
                if (column != null && column.ignoreNested()) continue;
                Class fCls = TypeHelp.fieldClass((Field)f, (Type)k);
                if (Map.class.isAssignableFrom(fCls) || Collection.class.isAssignableFrom(fCls) || fCls.isArray()) {
                    return DataType.MERGE;
                }
                if (nested || TypeHelp.likeCommon((Class)fCls)) continue;
                nested = true;
            }
            return nested ? DataType.NESTED : DataType.DEFAULT;
        });
    }

    public <T> T apply(Supplier<? extends T> action, final shz.core.transaction.TransactionDefinition definition) {
        if (definition == shz.core.transaction.TransactionDefinition.withDefaults()) {
            return this.apply(action, TransactionDefinition.withDefaults());
        }
        return this.apply(action, new TransactionDefinition(){

            public int getPropagationBehavior() {
                return definition.getPropagationBehavior();
            }

            public int getIsolationLevel() {
                return definition.getIsolationLevel();
            }

            public int getTimeout() {
                return definition.getTimeout();
            }

            public boolean isReadOnly() {
                return definition.isReadOnly();
            }

            public String getName() {
                return definition.getName();
            }
        });
    }

    public <T> T apply(Supplier<? extends T> action, TransactionDefinition definition) {
        TransactionStatus status = this.transactionManager.getTransaction(definition);
        try {
            T t = action.get();
            if (status.isCompleted()) {
                return t;
            }
            if (status.isRollbackOnly()) {
                this.transactionManager.rollback(status);
            } else {
                this.transactionManager.commit(status);
            }
            return t;
        }
        catch (Throwable t) {
            this.transactionManager.rollback(status);
            throw PRException.of((Throwable)t);
        }
    }

    public final void accept(Runnable action, TransactionDefinition definition) {
        this.apply(() -> {
            action.run();
            return null;
        }, definition);
    }

    protected final void setPs(PreparedStatement pst, Object[] params) throws SQLException {
        for (int i = 1; i <= params.length; ++i) {
            Object val = params[i - 1];
            if (val == null) {
                pst.setNull(i, 0);
                continue;
            }
            if (val instanceof CharSequence) {
                pst.setString(i, val.toString());
                continue;
            }
            if (val instanceof Integer) {
                pst.setInt(i, (Integer)val);
                continue;
            }
            if (val instanceof Long) {
                pst.setLong(i, (Long)val);
                continue;
            }
            if (val instanceof Byte) {
                pst.setByte(i, (Byte)val);
                continue;
            }
            if (val instanceof Boolean) {
                pst.setBoolean(i, (Boolean)val);
                continue;
            }
            if (val instanceof BigDecimal) {
                pst.setBigDecimal(i, (BigDecimal)val);
                continue;
            }
            if (val instanceof Date) {
                pst.setObject(i, val, 93);
                continue;
            }
            if (val instanceof ZonedDateTime) {
                pst.setObject(i, (Object)Timestamp.from(((ZonedDateTime)val).toInstant()), 93);
                continue;
            }
            if (val instanceof LocalDateTime) {
                pst.setObject(i, (Object)Timestamp.valueOf((LocalDateTime)val), 93);
                continue;
            }
            if (val instanceof Instant) {
                pst.setObject(i, (Object)Timestamp.from((Instant)val), 93);
                continue;
            }
            if (val instanceof LocalDate) {
                pst.setObject(i, (Object)Timestamp.valueOf(LocalDateTime.of((LocalDate)val, LocalTime.MIN)), 91);
                continue;
            }
            if (val instanceof LocalTime) {
                pst.setObject(i, (Object)Time.valueOf((LocalTime)val), 92);
                continue;
            }
            if (val instanceof Short) {
                pst.setShort(i, (Short)val);
                continue;
            }
            if (val instanceof Double) {
                pst.setDouble(i, (Double)val);
                continue;
            }
            if (val instanceof Character) {
                pst.setObject(i, val, 1);
                continue;
            }
            if (val instanceof BigInteger) {
                pst.setLong(i, ((BigInteger)val).longValue());
                continue;
            }
            if (val instanceof Float) {
                pst.setFloat(i, ((Float)val).floatValue());
                continue;
            }
            if (val instanceof Number) {
                pst.setObject(i, val, 2);
                continue;
            }
            pst.setObject(i, val);
        }
    }

    public final int[] executeBatch(int batchSize, String sql, List<Object[]> values) {
        int size = this.batchSize(batchSize);
        return (int[])this.jdbcTemplate.execute(sql, ps -> {
            int[] result = new int[values.size()];
            int batch = 0;
            int destPos = 0;
            for (Object[] params : values) {
                this.setPs(ps, params);
                ps.addBatch();
                if (++batch % size != 0) continue;
                this.executeBatch(ps, result, destPos);
                destPos += batch;
                batch = 0;
            }
            if (batch > 0) {
                this.executeBatch(ps, result, destPos);
            }
            return result;
        });
    }

    private void executeBatch(Statement stmt, int[] result, int destPos) {
        try {
            int[] rows = stmt.executeBatch();
            System.arraycopy(rows, 0, result, destPos, rows.length);
            stmt.clearBatch();
        }
        catch (SQLException e) {
            throw PRException.of((Throwable)e);
        }
    }

    public final int[] executeBatch(int batchSize, String ... sqls) {
        int size = this.batchSize(batchSize);
        return (int[])this.jdbcTemplate.execute(stmt -> {
            int[] result = new int[sqls.length];
            int batch = 0;
            int destPos = 0;
            for (String sql : sqls) {
                stmt.addBatch(sql);
                if (++batch % size != 0) continue;
                this.executeBatch(stmt, result, destPos);
                destPos += batch;
                batch = 0;
            }
            if (batch > 0) {
                this.executeBatch(stmt, result, destPos);
            }
            return result;
        });
    }

    protected final int insert(Consumer<Object> idSetter, String sql, Object ... params) {
        Integer execute = (Integer)this.jdbcTemplate.execute(conn -> conn.prepareStatement(sql, 1), ps -> {
            this.setPs(ps, params);
            int row = ps.executeUpdate();
            if (idSetter != null) {
                ResultSet rs = ps.getGeneratedKeys();
                if (rs.next()) {
                    idSetter.accept(rs.getObject(1));
                }
                rs.close();
            }
            return row;
        });
        return execute == null ? 0 : execute;
    }

    protected final int[] batchInsert(BiConsumer<Integer, Object> idSetter, int batchSize, String sql, List<Object[]> values) {
        int size = this.batchSize(batchSize);
        return (int[])this.jdbcTemplate.execute(conn -> conn.prepareStatement(sql, 1), ps -> {
            int[] result = new int[values.size()];
            int batch = 0;
            int destPos = 0;
            for (Object[] params : values) {
                this.setPs(ps, params);
                ps.addBatch();
                if (++batch % size != 0) continue;
                this.batchInsert0(idSetter, ps, result, destPos);
                destPos += batch;
                batch = 0;
            }
            if (batch > 0) {
                this.batchInsert0(idSetter, ps, result, destPos);
            }
            return result;
        });
    }

    private void batchInsert0(BiConsumer<Integer, Object> idSetter, Statement stmt, int[] result, int destPos) {
        ResultSet rs = null;
        try {
            int[] rows = stmt.executeBatch();
            if (idSetter != null) {
                rs = stmt.getGeneratedKeys();
            }
            System.arraycopy(rows, 0, result, destPos, rows.length);
            stmt.clearBatch();
            if (rs != null) {
                while (rs.next()) {
                    idSetter.accept(destPos++, rs.getObject(1));
                }
            }
        }
        catch (SQLException e) {
            throw PRException.of((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public final int update(String sql, Object ... params) {
        return this.jdbcTemplate.update(sql, ps -> this.setPs(ps, params));
    }

    public final int delete(String sql, Object ... params) {
        return this.update(sql, params);
    }

    public final int count(String sql, Object ... params) {
        Integer execute = (Integer)this.jdbcTemplate.execute(sql, ps -> {
            this.setPs(ps, params);
            ResultSet rs = ps.executeQuery();
            int count = rs.next() ? rs.getInt(1) : 0;
            rs.close();
            return count;
        });
        return execute == null ? 0 : execute;
    }

    protected final Map<String, Set<String>> tableSchemaNameMap() {
        Connection conn;
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        if (dataSource == null) {
            return Collections.emptyMap();
        }
        try {
            conn = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw PRException.of((Throwable)e);
        }
        return Table.get(conn, null, null, "%", null).stream().filter(table -> "TABLE".equals(table.getTableType())).collect(Collectors.groupingBy(Table::getTableSchem, Collectors.mapping(Table::getTableName, Collectors.toSet())));
    }
}

