/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import shz.core.PRException;
import shz.core.cl.ClassLoaderHelp;
import shz.jdbc.generate.Generator;

public abstract class DefaultGenerator
extends Generator {
    protected final Properties properties;

    protected DefaultGenerator(Properties properties) {
        this.properties = properties;
    }

    protected DefaultGenerator(String driverClassName, String url, String user, String password) {
        this.properties = new Properties();
        this.properties.put("driverClassName", driverClassName);
        this.properties.put("url", url);
        this.properties.put("user", user);
        this.properties.put("password", password);
    }

    @Override
    protected Connection conn() {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)this.properties);
        prop.put("useInformationSchema", "true");
        prop.put("remarksReporting", "true");
        String url = prop.getProperty("url");
        try {
            return DriverManager.getConnection(url, prop);
        }
        catch (SQLException e) {
            ClassLoaderHelp.load((String)prop.getProperty("driverClassName"));
            try {
                return DriverManager.getConnection(url, prop);
            }
            catch (SQLException e2) {
                throw PRException.of((Throwable)e2);
            }
        }
    }
}

