/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate;

import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import shz.core.NullHelp;
import shz.core.StringHelp;
import shz.core.ToString;
import shz.core.io.FileHelp;
import shz.jdbc.generate.FieldNames;
import shz.jdbc.generate.FileTemplates;
import shz.jdbc.generate.GeneratorHelper;
import shz.jdbc.generate.GlobalInfo;
import shz.jdbc.generate.Imports;
import shz.jdbc.model.Table;

public abstract class Generator
extends GeneratorHelper
implements FieldNames,
Imports,
FileTemplates {
    protected String moduleName;

    protected abstract Connection conn();

    protected String folder() {
        String modules;
        String path = FileHelp.formatPath((String)System.getProperty("user.dir"));
        int idx = path.indexOf(modules = "/modules/");
        if (idx == -1) {
            return path;
        }
        this.moduleName = path.substring(idx + modules.length());
        return path.substring(0, idx);
    }

    protected abstract String basePackage();

    protected boolean disabled(Table table) {
        String tableName = table.getTableName().toLowerCase();
        if (tableName.endsWith("_detail")) {
            return true;
        }
        String remarks = table.getRemarks();
        return NullHelp.nonBlank((CharSequence)remarks) && (remarks.endsWith("\u5173\u7cfb") || remarks.endsWith("\u5173\u7cfb\u8868") || remarks.endsWith("\u4e2d\u95f4\u8868"));
    }

    protected String moduleName(Table table) {
        return this.moduleName;
    }

    protected String entityClassName(Table table) {
        return StringHelp.underlineToHump((String)table.getTableName(), (boolean)true);
    }

    protected Class<?> superEntityClass(Table table) {
        return null;
    }

    protected String requestMapping(Table table) {
        return ToString.joining(Arrays.asList(table.getTableName().split("_")), (CharSequence)"/", (CharSequence)"/", (CharSequence)"").toLowerCase();
    }

    protected String tableDescription(Table table) {
        String remarks = table.getRemarks();
        if (NullHelp.nonBlank((CharSequence)remarks) && remarks.endsWith("\u8868")) {
            remarks = remarks.substring(0, remarks.length() - 1);
        }
        return remarks;
    }

    protected String tableTag(Table table) {
        String s = table.getTableName().toUpperCase();
        if (s.startsWith("T_")) {
            return s.substring(2);
        }
        if (s.startsWith("SYS_")) {
            return s.substring(4);
        }
        return s;
    }

    protected String redisLockKeysClassName() {
        return "com.xxx.redis.key.RedisLockKeys";
    }

    public final void generate(String catalog, String schemaPattern, String tableNamePattern, String[] types, Boolean disabled) {
        List<Table> tables = Table.get(this.conn(), catalog, schemaPattern, tableNamePattern, types);
        NullHelp.requireNonEmpty(tables, (String)"\u8868\u4fe1\u606f\u4e3a\u7a7a");
        tables.forEach(table -> {
            GlobalInfo info = new GlobalInfo();
            info.folder = (String)NullHelp.requireNonBlank((Object)this.folder());
            info.basePackage = (String)NullHelp.requireNonBlank((Object)this.basePackage());
            info.helper = this;
            info.table = table;
            info.disabled = disabled == null ? this.disabled((Table)table) : disabled.booleanValue();
            info.moduleName = (String)NullHelp.requireNonBlank((Object)this.moduleName((Table)table));
            info.entityClassName = (String)NullHelp.requireNonBlank((Object)this.entityClassName((Table)table));
            info.superEntityClass = this.superEntityClass((Table)table);
            info.requestMapping = (String)NullHelp.requireNonBlank((Object)this.requestMapping((Table)table));
            info.tableDescription = this.tableDescription((Table)table);
            info.tableTag = this.tableTag((Table)table);
            info.redisLockKeysClassName = this.redisLockKeysClassName();
            info.fieldNames = this;
            info.imports = this;
            info.templates = this;
            info.write();
        });
    }

    public final void generate(String schemaPattern, String tableNamePattern, Boolean disabled) {
        this.generate(null, schemaPattern, tableNamePattern, null, disabled);
    }

    public final void generate(String tableNamePattern, Boolean disabled) {
        this.generate(null, null, tableNamePattern, null, disabled);
    }

    public final void generate(String tableNamePattern) {
        this.generate(null, null, tableNamePattern, null, null);
    }

    public final void generateEnabled(String tableNamePattern) {
        this.generate(null, null, tableNamePattern, null, Boolean.TRUE);
    }
}

