/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate;

import shz.core.StringHelp;
import shz.jdbc.model.Column;

public abstract class GeneratorHelper {
    protected String fieldName(Column column) {
        return StringHelp.underlineToHump((String)column.getColumnName().toLowerCase(), (boolean)false);
    }

    protected String getType(Column column) {
        switch (column.getDataType()) {
            case -7: 
            case 16: {
                return "Boolean";
            }
            case -6: {
                return "Byte";
            }
            case 5: {
                return "Short";
            }
            case 4: {
                return "Integer";
            }
            case -5: {
                return "Long";
            }
            case 6: {
                return "Float";
            }
            case 8: {
                return "Double";
            }
            case 2: 
            case 3: {
                if (column.getDecimalDigits() > 0 || column.getColumnSize() >= 19) {
                    return "BigDecimal";
                }
                if (column.getColumnSize() >= 10) {
                    return "Long";
                }
                if (column.getColumnSize() >= 5) {
                    return "Integer";
                }
                if (column.getColumnSize() >= 3) {
                    return "Short";
                }
                if (column.getColumnSize() >= 2) {
                    return "Byte";
                }
                return "Boolean";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: 
            case 2009: 
            case 2011: {
                return "String";
            }
            case 91: {
                return "LocalDate";
            }
            case 92: {
                return "LocalTime";
            }
            case 93: 
            case 2013: 
            case 2014: {
                return "LocalDateTime";
            }
        }
        return "String";
    }

    protected String getImport(String type) {
        switch (type) {
            case "BigDecimal": {
                return "import java.math.BigDecimal;";
            }
            case "LocalDate": {
                return "import java.time.LocalDate;";
            }
            case "LocalTime": {
                return "import java.time.LocalTime;";
            }
            case "LocalDateTime": {
                return "import java.time.LocalDateTime;";
            }
        }
        return null;
    }
}

