/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate.template;

import java.util.LinkedList;
import java.util.List;
import shz.jdbc.generate.FileTemplate;

public class DefaultApiClientFallbackTemplate
extends FileTemplate {
    @Override
    protected String path() {
        return "api/api-" + this.info.getModuleName();
    }

    @Override
    public String packageName() {
        return this.info.getBasePackage() + ".api." + this.info.getModuleName() + ".factory";
    }

    @Override
    public String className() {
        return this.info.getTemplates().entityTemplate().className() + "ClientFallbackFactory";
    }

    @Override
    protected List<String> annotations() {
        LinkedList<String> annotations = new LinkedList<String>();
        annotations.add("@Slf4j");
        this.imports.add("import lombok.extern.slf4j.Slf4j;");
        return annotations;
    }

    @Override
    protected String classDescription() {
        FileTemplate clientTemplate = this.info.getTemplates().apiClientTemplate();
        this.imports.add("import org.springframework.cloud.openfeign.FallbackFactory;");
        this.imports.add(clientTemplate.getImport());
        return "public class " + this.className() + " implements FallbackFactory<" + clientTemplate.className() + ">";
    }

    @Override
    protected List<String> content() {
        LinkedList<String> content = new LinkedList<String>();
        FileTemplate clientTemplate = this.info.getTemplates().apiClientTemplate();
        content.add("    @Override");
        content.add("    public " + clientTemplate.className() + " create(Throwable cause) {");
        content.add("        return InterfaceProxy.getProxy(" + clientTemplate.className() + ".class, p -> {");
        content.add("            log.error(cause.getMessage(), cause);");
        content.add("            return Response.fail(ServerFailure.GATEWAY_TIMEOUT);");
        content.add("        });");
        content.add("    }");
        this.imports.add("import shz.core.InterfaceProxy;");
        this.imports.add("import shz.core.model.Response;");
        this.imports.add("import shz.core.msg.ServerFailure;");
        return content;
    }

    @Override
    protected boolean disabled() {
        return true;
    }
}

