/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate.template;

import java.util.LinkedList;
import java.util.List;
import shz.core.NullHelp;
import shz.core.StringHelp;
import shz.jdbc.generate.FileTemplate;

public class DefaultControllerTemplate
extends FileTemplate {
    @Override
    protected String path() {
        return "modules/" + this.info.getModuleName();
    }

    @Override
    public String packageName() {
        return this.info.getBasePackage() + "." + this.info.getModuleName() + ".controller";
    }

    @Override
    public String className() {
        return this.info.getTemplates().entityTemplate().className() + "Controller";
    }

    @Override
    protected String comment() {
        String remarks = this.info.getTable().getRemarks();
        if (NullHelp.isBlank((CharSequence)remarks)) {
            return super.comment();
        }
        if (remarks.endsWith("\u8868")) {
            remarks = remarks.substring(0, remarks.length() - 1);
        }
        if (!remarks.endsWith("\u7ba1\u7406")) {
            remarks = remarks + "\u7ba1\u7406";
        }
        return "/**\n * " + remarks + "\n */";
    }

    @Override
    protected List<String> annotations() {
        LinkedList<String> annotations = new LinkedList<String>();
        annotations.add("@RestController");
        annotations.add("@RequestMapping(\"" + this.info.getRequestMapping() + "\")");
        this.imports.add("import org.springframework.web.bind.annotation.RestController;");
        this.imports.add("import org.springframework.web.bind.annotation.RequestMapping;");
        return annotations;
    }

    @Override
    protected String classDescription() {
        return "public class " + this.className();
    }

    @Override
    protected List<String> content() {
        LinkedList<String> content = new LinkedList<String>();
        FileTemplate addTemplate = this.info.getTemplates().addVoTemplate();
        FileTemplate updateTemplate = this.info.getTemplates().updateVoTemplate();
        FileTemplate queryTemplate = this.info.getTemplates().queryVoTemplate();
        FileTemplate detailTemplate = this.info.getTemplates().detailVoTemplate();
        FileTemplate serviceTemplate = this.info.getTemplates().serviceTemplate();
        String serviceFieldName = StringHelp.pojo((String)serviceTemplate.className());
        String desc = this.info.getTableDescription();
        content.add("    @Autowired");
        content.add("    " + serviceTemplate.className() + " " + serviceFieldName + ";\n");
        content.add("    /**");
        content.add("     * \u65b0\u589e" + desc);
        content.add("     */");
        content.add("    @PostMapping");
        content.add("    public Response<Long> add(@RequestBody @Valid " + addTemplate.className() + " vo) {");
        content.add("        Long id = " + serviceFieldName + ".add(vo);");
        content.add("        return Response.ok(id);");
        content.add("    }\n");
        content.add("    /**");
        content.add("     * \u7f16\u8f91" + desc);
        content.add("     */");
        content.add("    @PutMapping");
        content.add("    public Response<Void> update(@RequestBody @Valid " + updateTemplate.className() + " vo) {");
        content.add("        " + serviceFieldName + ".update(vo);");
        content.add("        return Response.ok();");
        content.add("    }\n");
        content.add("    /**");
        content.add("     * \u5220\u9664" + desc);
        content.add("     *");
        content.add("     * @param ids " + desc + "id\u96c6");
        content.add("     */");
        content.add("    @DeleteMapping(\"{ids}\")");
        content.add("    public Response<Void> delete(@PathVariable(\"ids\") List<Long> ids) {");
        content.add("        " + serviceFieldName + ".delete(ids);");
        content.add("        return Response.ok();");
        content.add("    }\n");
        content.add("    /**");
        content.add("     * " + desc + "\u5206\u9875\u5217\u8868");
        content.add("     */");
        content.add("    @PostMapping(\"page\")");
        content.add("    public Response<PageInfo<" + queryTemplate.className() + ".Vo>> page(@RequestBody @Valid PageVo<" + queryTemplate.className() + ", " + queryTemplate.className() + ".Vo> vo) {");
        content.add("        PageInfo<" + queryTemplate.className() + ".Vo> pageInfo = " + serviceFieldName + ".page(vo);");
        content.add("        return Response.ok(pageInfo);");
        content.add("    }\n");
        content.add("    /**");
        content.add("     * " + desc + "\u5217\u8868");
        content.add("     */");
        content.add("    @PostMapping(\"list\")");
        content.add("    public Response<List<" + queryTemplate.className() + ".Vo>> list(@RequestBody @Valid " + queryTemplate.className() + " vo) {");
        content.add("        List<" + queryTemplate.className() + ".Vo> list = " + serviceFieldName + ".list(vo);");
        content.add("        return Response.ok(list);");
        content.add("    }\n");
        content.add("    /**");
        content.add("     * " + desc + "\u8be6\u60c5");
        content.add("     *");
        content.add("     * @param id " + desc + "id");
        content.add("     */");
        content.add("    @GetMapping(\"detail/{id}\")");
        content.add("    public Response<" + detailTemplate.className() + "> detail(@PathVariable(\"id\") Long id) {");
        content.add("        " + detailTemplate.className() + " detail = " + serviceFieldName + ".detail(id);");
        content.add("        return Response.ok(detail);");
        content.add("    }");
        this.imports.add(addTemplate.getImport());
        this.imports.add(updateTemplate.getImport());
        this.imports.add(queryTemplate.getImport());
        this.imports.add(detailTemplate.getImport());
        this.imports.add(serviceTemplate.getImport());
        this.imports.add(this.info.getImports().validImport());
        this.imports.add("import org.springframework.beans.factory.annotation.Autowired;");
        this.imports.add("import org.springframework.web.bind.annotation.*;");
        this.imports.add("import shz.core.model.Response;");
        this.imports.add("import shz.core.model.PageInfo;");
        this.imports.add("import shz.spring.model.PageVo;");
        this.imports.add("import java.util.List;");
        return content;
    }
}

