/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate.template;

import java.util.LinkedList;
import java.util.List;
import shz.core.orm.entity.RecordEntity;
import shz.core.orm.entity.TreeEntity;
import shz.jdbc.generate.FileTemplate;

public class DefaultServiceImplTemplate
extends FileTemplate {
    @Override
    protected String path() {
        return "modules/" + this.info.getModuleName();
    }

    @Override
    public String packageName() {
        return this.info.getBasePackage() + "." + this.info.getModuleName() + ".service.impl";
    }

    @Override
    public String className() {
        return this.info.getTemplates().entityTemplate().className() + "ServiceImpl";
    }

    @Override
    protected List<String> annotations() {
        LinkedList<String> annotations = new LinkedList<String>();
        annotations.add("@Service");
        this.imports.add("import org.springframework.stereotype.Service;");
        return annotations;
    }

    @Override
    protected String classDescription() {
        FileTemplate entityTemplate = this.info.getTemplates().entityTemplate();
        FileTemplate serviceTemplate = this.info.getTemplates().serviceTemplate();
        this.imports.add(entityTemplate.getImport());
        this.imports.add(serviceTemplate.getImport());
        if (this.info.getSuperEntityClass() != null && RecordEntity.class.isAssignableFrom(this.info.getSuperEntityClass())) {
            this.imports.add("import shz.core.orm.record.RecordService;");
            return "class " + this.className() + " extends RecordService<" + entityTemplate.className() + "> implements " + serviceTemplate.className();
        }
        FileTemplate repositoryTemplate = this.info.getTemplates().repositoryTemplate();
        this.imports.add("import shz.core.orm.BaseService;");
        this.imports.add(repositoryTemplate.getImport());
        return "class " + this.className() + " extends BaseService<" + entityTemplate.className() + ", " + repositoryTemplate.className() + "> implements " + serviceTemplate.className();
    }

    @Override
    protected List<String> content() {
        LinkedList<String> content = new LinkedList<String>();
        FileTemplate entityTemplate = this.info.getTemplates().entityTemplate();
        FileTemplate addTemplate = this.info.getTemplates().addVoTemplate();
        FileTemplate updateTemplate = this.info.getTemplates().updateVoTemplate();
        FileTemplate queryTemplate = this.info.getTemplates().queryVoTemplate();
        FileTemplate detailTemplate = this.info.getTemplates().detailVoTemplate();
        String lockKey = this.redisLockKey();
        String desc = this.info.getTableDescription();
        if (this.info.getSuperEntityClass() != null && TreeEntity.class.isAssignableFrom(this.info.getSuperEntityClass())) {
            content.add("    @RedisLock(" + lockKey + ")");
            content.add("    public Long add(@LockKey(\"parentId\") " + addTemplate.className() + " vo) {");
            content.add("        " + entityTemplate.className() + " entity = FieldSetter.copy(vo, new " + entityTemplate.className() + "());");
            content.add("        service.insertTree(entity, tree -> ClientFailureMsg.requireNon(checkUniqueForInsert(tree, " + entityTemplate.className() + "::getParentId, " + entityTemplate.className() + "::getCode), \"" + desc + "\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\"), \"" + desc + "\");");
            content.add("        return entity.getId();");
            content.add("    }\n");
            content.add("    @RedisLock(" + lockKey + ")");
            content.add("    public void update(@LockKey(\"parentId\") " + updateTemplate.className() + " vo) {");
            content.add("        " + entityTemplate.className() + " entity = FieldSetter.copy(vo, new " + entityTemplate.className() + "());");
            content.add("        service.updateTree(entity, tree -> ClientFailureMsg.requireNon(checkUniqueForUpdate(tree, " + entityTemplate.className() + "::getParentId, " + entityTemplate.className() + "::getCode), \"" + desc + "\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\"), \"" + desc + "\");");
            content.add("    }\n");
            content.add("    @Override");
            content.add("    public void delete(Collection<?> ids) {");
            content.add("        Set<?> idSet = ToSet.asSet(ids);");
            content.add("        checkId(idSet);\n");
            content.add("        List<" + entityTemplate.className() + "> entities = selectByIds(idSet);");
            content.add("        if (entities.isEmpty()) return;");
            content.add("        Set<Long> realIds = ToSet.explicitCollect(entities.stream().map(" + entityTemplate.className() + "::getId), entities.size());\n");
            content.add("        checkBoundData(" + entityTemplate.className() + ".class, \"parentId\", realIds, \"" + desc + "id%s\u5b58\u5728\u5b50" + desc + "\");");
            content.add("        service.deleteTree(entities);");
            content.add("    }\n");
        } else {
            content.add("    @RedisLock(" + lockKey + ")");
            content.add("    public Long add(@LockKey(\"code\") " + addTemplate.className() + " vo) {");
            content.add("        " + entityTemplate.className() + " entity = FieldSetter.copy(vo, new " + entityTemplate.className() + "());");
            content.add("        ClientFailureMsg.requireNon(checkUniqueForInsert(entity, " + entityTemplate.className() + "::getCode), \"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\");");
            content.add("        insert(entity);");
            content.add("        return entity.getId();");
            content.add("    }\n");
            content.add("    @RedisLock(" + lockKey + ")");
            content.add("    public void update(@LockKey(\"code\") " + updateTemplate.className() + " vo) {");
            content.add("        " + entityTemplate.className() + " oldEntity = selectById(vo.getId());");
            content.add("        ClientFailureMsg.requireNonNull(oldEntity, \"" + desc + "\u4e0d\u5b58\u5728\");\n");
            content.add("        " + entityTemplate.className() + " entity = FieldSetter.copy(vo, new " + entityTemplate.className() + "());");
            content.add("        ClientFailureMsg.requireNon(checkUniqueForUpdate(entity, " + entityTemplate.className() + "::getCode), \"\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\");");
            content.add("        updateById(entity);");
            content.add("    }\n");
            content.add("    @Override");
            content.add("    public void delete(Collection<?> ids) {");
            content.add("        Set<?> idSet = ToSet.asSet(ids);");
            content.add("        checkId(idSet);\n");
            content.add("        List<" + entityTemplate.className() + "> entities = selectByIds(idSet);");
            content.add("        if (entities.isEmpty()) return;");
            content.add("        Set<Long> realIds = ToSet.explicitCollect(entities.stream().map(" + entityTemplate.className() + "::getId), entities.size());\n");
            content.add("        super.delete(realIds);");
            content.add("    }\n");
        }
        content.add("    @Override");
        content.add("    public PageInfo<" + queryTemplate.className() + ".Vo> page(PageVo<" + queryTemplate.className() + ", " + queryTemplate.className() + ".Vo> vo) {");
        content.add("        PageInfo<" + entityTemplate.className() + "> page = selectPage(vo.simple(), vo.getData());");
        content.add("        return page.map(entity -> FieldSetter.copy(entity, new " + queryTemplate.className() + ".Vo()));");
        content.add("    }\n");
        content.add("    @Override");
        content.add("    public List<" + queryTemplate.className() + ".Vo> list(" + queryTemplate.className() + " vo) {");
        content.add("        List<" + entityTemplate.className() + "> entities = selectList(vo);");
        content.add("        return ToList.explicitCollect(entities.stream().map(entity -> FieldSetter.copy(entity, new " + queryTemplate.className() + ".Vo())), entities.size());");
        content.add("    }\n");
        content.add("    @Override");
        content.add("    public " + detailTemplate.className() + " detail(Long id) {");
        content.add("        " + entityTemplate.className() + " entity = selectById(id);");
        content.add("        ClientFailureMsg.requireNonNull(entity, \"" + desc + "\u4e0d\u5b58\u5728\");");
        content.add("        return FieldSetter.copy(entity, new " + detailTemplate.className() + "());");
        content.add("    }");
        this.imports.add(entityTemplate.getImport());
        this.imports.add(addTemplate.getImport());
        this.imports.add(updateTemplate.getImport());
        this.imports.add(queryTemplate.getImport());
        this.imports.add(detailTemplate.getImport());
        this.imports.add("import " + this.info.getRedisLockKeysClassName() + ";");
        this.imports.add("import java.util.Collection;");
        this.imports.add("import java.util.List;");
        this.imports.add("import java.util.Set;");
        this.imports.add("import shz.redis.RedisLock;");
        this.imports.add("import shz.core.lock.LockKey;");
        this.imports.add("import shz.core.msg.ClientFailureMsg;");
        this.imports.add("import shz.core.FieldSetter;");
        this.imports.add("import shz.core.ToList;");
        this.imports.add("import shz.core.ToSet;");
        this.imports.add("import shz.core.model.PageInfo;");
        this.imports.add("import shz.spring.model.PageVo;");
        return content;
    }

    private String redisLockKey() {
        int idx = this.info.getRedisLockKeysClassName().lastIndexOf(46);
        if (idx == -1) {
            return this.info.getRedisLockKeysClassName() + "." + this.info.getTableTag();
        }
        return this.info.getRedisLockKeysClassName().substring(idx + 1) + "." + this.info.getTableTag();
    }
}

