/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate.template;

import java.util.LinkedList;
import java.util.List;
import shz.core.orm.entity.RecordEntity;
import shz.jdbc.generate.FileTemplate;

public class DefaultServiceTemplate
extends FileTemplate {
    @Override
    protected String path() {
        return "modules/" + this.info.getModuleName();
    }

    @Override
    public String packageName() {
        return this.info.getBasePackage() + "." + this.info.getModuleName() + ".service";
    }

    @Override
    public String className() {
        return this.info.getTemplates().entityTemplate().className() + "Service";
    }

    @Override
    protected String classDescription() {
        if (this.info.getSuperEntityClass() != null && RecordEntity.class.isAssignableFrom(this.info.getSuperEntityClass())) {
            return "public interface " + this.className();
        }
        FileTemplate entityTemplate = this.info.getTemplates().entityTemplate();
        this.imports.add("import shz.core.orm.IService;");
        this.imports.add(entityTemplate.getImport());
        return "public interface " + this.className() + " extends IService<" + entityTemplate.className() + ">";
    }

    @Override
    protected List<String> content() {
        LinkedList<String> content = new LinkedList<String>();
        FileTemplate entityTemplate = this.info.getTemplates().entityTemplate();
        FileTemplate addTemplate = this.info.getTemplates().addVoTemplate();
        FileTemplate updateTemplate = this.info.getTemplates().updateVoTemplate();
        FileTemplate queryTemplate = this.info.getTemplates().queryVoTemplate();
        FileTemplate detailTemplate = this.info.getTemplates().detailVoTemplate();
        content.add("    Long add(" + addTemplate.className() + " vo);\n");
        content.add("    void update(" + updateTemplate.className() + " vo);\n");
        content.add("    PageInfo<" + queryTemplate.className() + ".Vo> page(PageVo<" + queryTemplate.className() + ", " + queryTemplate.className() + ".Vo> vo);\n");
        content.add("    List<" + queryTemplate.className() + ".Vo> list(" + queryTemplate.className() + " vo);\n");
        content.add("    " + detailTemplate.className() + " detail(Long id);");
        this.imports.add(entityTemplate.getImport());
        this.imports.add(addTemplate.getImport());
        this.imports.add(updateTemplate.getImport());
        this.imports.add(queryTemplate.getImport());
        this.imports.add(detailTemplate.getImport());
        this.imports.add("import shz.core.model.PageInfo;");
        this.imports.add("import shz.spring.model.PageVo;");
        this.imports.add("import java.util.List;");
        return content;
    }
}

