/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.handler;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import shz.core.StringHelp;
import shz.core.model.PageInfo;
import shz.core.orm.sql.handler.SqlHandler;
import shz.core.orm.sql.segment.Segment;

public class MysqlSqlHandler
implements SqlHandler {
    public void escape(StringBuilder sb, Object val) {
        if (val == null) {
            sb.append("null");
        } else if (val instanceof Boolean || val instanceof Number) {
            sb.append(val);
        } else if (val instanceof ZonedDateTime) {
            sb.append('\'').append(Timestamp.from(((ZonedDateTime)val).toInstant())).append('\'');
        } else if (val instanceof LocalDateTime) {
            sb.append('\'').append(Timestamp.valueOf((LocalDateTime)val)).append('\'');
        } else if (val instanceof Instant) {
            sb.append('\'').append(Timestamp.from((Instant)val)).append('\'');
        } else if (val instanceof LocalDate) {
            sb.append('\'').append(Timestamp.valueOf(LocalDateTime.of((LocalDate)val, LocalTime.MIN))).append('\'');
        } else if (val instanceof Date) {
            sb.append('\'').append(Timestamp.from(Instant.ofEpochMilli(((Date)val).getTime()))).append('\'');
        } else if (val instanceof LocalTime) {
            sb.append('\'').append(Time.valueOf((LocalTime)val)).append('\'');
        } else {
            sb.append('\'');
            String s = val.toString();
            if (!StringHelp.escape(sb::append, sb::append, (String)s, (char)'\'')) {
                sb.append(s);
            }
            sb.append('\'');
        }
    }

    public final void wrap(StringBuilder sb, Object val) {
        sb.append('`').append(val).append('`');
    }

    public final boolean supportIgnore() {
        return true;
    }

    public final void page(StringBuilder sb, PageInfo<?> pageInfo) {
        sb.append(" LIMIT ").append(pageInfo.getMin()).append(',').append(pageInfo.getSize());
    }

    public final String humpToUnderline(String name) {
        return super.humpToUnderline(name);
    }

    public final String aliasToField(String name) {
        return super.aliasToField(name);
    }

    public final List<Segment> segments(String sql) {
        return super.segments(sql);
    }
}

