/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.handler;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import shz.core.StringHelp;
import shz.core.model.PageInfo;
import shz.core.orm.sql.handler.SqlHandler;
import shz.core.orm.sql.segment.Segment;
import shz.core.time.TimeHelp;

public class PostgresSqlHandler
implements SqlHandler {
    public void escape(StringBuilder sb, Object val) {
        if (val == null) {
            sb.append("null");
        } else if (val instanceof Boolean || val instanceof Number) {
            sb.append(val);
        } else if (val instanceof Timestamp) {
            sb.append("TO_TIMESTAMP('").append(TimeHelp.format((Timestamp)((Timestamp)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof ZonedDateTime) {
            sb.append("TO_TIMESTAMP('").append(TimeHelp.format((LocalDateTime)((ZonedDateTime)val).toLocalDateTime())).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof LocalDateTime) {
            sb.append("TO_TIMESTAMP('").append(TimeHelp.format((LocalDateTime)((LocalDateTime)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof Instant) {
            sb.append("TO_TIMESTAMP('").append(TimeHelp.format((Instant)((Instant)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof LocalDate) {
            sb.append("TO_DATE('").append(TimeHelp.format((LocalDate)((LocalDate)val), (DateTimeFormatter)TimeHelp.DATE_PATTERN)).append("','YYYY-MM-DD')");
        } else if (val instanceof Date) {
            sb.append("TO_TIMESTAMP('").append(TimeHelp.format((Date)((Date)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof LocalTime) {
            sb.append("TO_TIMESTAMP('").append(TimeHelp.format((LocalTime)((LocalTime)val), (DateTimeFormatter)TimeHelp.TIME_PATTERN)).append("','HH24:MI:SS')");
        } else {
            sb.append('\'');
            String s = val.toString();
            if (!StringHelp.escape(sb::append, sb::append, (String)s, (char)'\'')) {
                sb.append(s);
            }
            sb.append('\'');
        }
    }

    public final void wrap(StringBuilder sb, Object val) {
        sb.append('\"').append(val).append('\"');
    }

    public final void page(StringBuilder sb, PageInfo<?> pageInfo) {
        sb.append(" LIMIT ").append(pageInfo.getSize()).append(" OFFSET ").append(pageInfo.getMin());
    }

    public final String humpToUnderline(String name) {
        return super.humpToUnderline(name);
    }

    public final String aliasToField(String name) {
        return super.aliasToField(name);
    }

    public final List<Segment> segments(String sql) {
        return super.segments(sql);
    }
}

