/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import shz.jdbc.JdbcService;

@Configuration(proxyBeanMethods=false)
class JdbcAutoConfiguration {
    JdbcAutoConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(name={"jdbc.service"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnMissingBean(value={JdbcTemplate.class})
    JdbcTemplate JdbcTemplate(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(dataSource);
        return jdbcTemplate;
    }

    @Bean
    @ConditionalOnBean(value={JdbcTemplate.class, PlatformTransactionManager.class})
    @ConditionalOnMissingBean(value={JdbcService.class})
    JdbcService jdbcService(JdbcTemplate jdbcTemplate, PlatformTransactionManager transactionManager) {
        JdbcService jdbcService = new JdbcService();
        jdbcService.setJdbcTemplate(jdbcTemplate);
        jdbcService.setTransactionManager(transactionManager);
        return jdbcService;
    }
}

