/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import shz.core.NullHelp;
import shz.core.ToList;
import shz.core.io.FileHelp;
import shz.core.io.IOHelp;
import shz.core.reference.ZReference;
import shz.jdbc.generate.GlobalInfo;
import shz.jdbc.model.Column;

public abstract class FileTemplate {
    protected GlobalInfo info;
    protected final Set<String> imports = new HashSet<String>();
    private static File redisLockKeysFile;
    private static boolean redisLockKeysFileNonExist;

    protected abstract String path();

    protected abstract String packageName();

    public abstract String className();

    protected String comment() {
        return "";
    }

    protected List<String> annotations() {
        return new LinkedList<String>();
    }

    protected String classDescription() {
        return "public class " + this.className();
    }

    protected List<String> content() {
        return new LinkedList<String>();
    }

    protected boolean override() {
        return false;
    }

    protected boolean disabled() {
        return false;
    }

    protected boolean enabled() {
        return false;
    }

    protected final String fieldName(Column column) {
        return this.info.helper.fieldName(column);
    }

    protected final String getType(Column column) {
        String type = this.info.helper.getType(column);
        String typeImport = this.info.helper.getImport(type);
        if (typeImport != null) {
            this.imports.add(typeImport);
        }
        return type;
    }

    public final String getImport() {
        return "import " + this.packageName() + "." + this.className() + ";";
    }

    final void write() {
        if (this.disabled() || !this.enabled() && this.info.disabled) {
            return;
        }
        File folder = NullHelp.nonBlank((CharSequence)this.path()) ? new File(this.info.folder, this.path()) : new File(this.info.folder);
        File javaFolder = new File(folder, "src/main/java/" + this.packageName().replaceAll("\\.", "/"));
        NullHelp.requireNon((!javaFolder.mkdirs() && !javaFolder.exists() ? 1 : 0) != 0);
        File javaFile = new File(javaFolder, this.className() + ".java");
        boolean exists = javaFile.exists();
        if (exists && !this.override()) {
            return;
        }
        LinkedList<String> data = new LinkedList<String>();
        data.add("package " + this.packageName() + ";\n");
        String comment = this.comment();
        List<String> annotations = this.annotations();
        String classDescription = this.classDescription();
        List<String> content = this.content();
        if (!this.imports.isEmpty()) {
            List sort = ToList.explicitCollect(this.imports.stream(), (int)this.imports.size());
            sort.sort(Collator.getInstance(Locale.ENGLISH));
            sort.set(sort.size() - 1, (String)sort.get(sort.size() - 1) + "\n");
            data.addAll(sort);
            this.imports.clear();
        }
        if (NullHelp.nonBlank((CharSequence)comment)) {
            data.add(comment);
        }
        data.addAll(annotations);
        data.add(classDescription + " {");
        data.addAll(content);
        data.add("}");
        IOHelp.write((BufferedWriter)IOHelp.newBufferedWriter((Path)javaFile.toPath()), data);
        if (this == this.info.getTemplates().serviceImplTemplate()) {
            File file = this.getRedisLockKeysFile();
            if (file != null) {
                String s = "    String " + this.info.tableTag + " = \"LOCK:" + this.info.tableTag + "\";";
                ArrayList<String> list = new ArrayList<String>();
                FileHelp.readString((File)file, list);
                if (((String)list.get(list.size() - 1)).equals("}") && !list.contains(s)) {
                    list.set(list.size() - 1, s);
                    list.add("}");
                    FileHelp.writeString((File)file, list);
                }
            }
        } else if (this == this.info.getTemplates().apiClientFallbackTemplate()) {
            File resourceFolder = new File(folder, "src/main/resources/META-INF/spring");
            NullHelp.requireNon((!resourceFolder.mkdirs() && !resourceFolder.exists() ? 1 : 0) != 0);
            File resourceFile = new File(resourceFolder, "org.springframework.boot.autoconfigure.AutoConfiguration.imports");
            String s = this.packageName() + "." + this.className();
            if (!resourceFile.exists()) {
                FileHelp.writeChars((File)resourceFile, (char[])s.toCharArray());
            } else {
                ZReference mark = new ZReference();
                IOHelp.read((BufferedReader)IOHelp.newBufferedReader((Path)resourceFile.toPath()), line -> {
                    mark.set(s.equals(line));
                    return mark.get();
                });
                if (!mark.get()) {
                    IOHelp.write((BufferedWriter)IOHelp.newBufferedWriter((Path)resourceFile.toPath(), (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND}), (char[])s.toCharArray());
                }
            }
        }
    }

    private File getRedisLockKeysFile() {
        if (redisLockKeysFile == null && !redisLockKeysFileNonExist) {
            String s = this.info.getRedisLockKeysClassName().replace('.', '/');
            File file = FileHelp.findFile((String)("**/" + s + ".java"));
            if (file != null) {
                redisLockKeysFile = file;
            } else {
                redisLockKeysFileNonExist = true;
            }
        }
        return redisLockKeysFile;
    }
}

