/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate.template;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import shz.core.AccessibleHelp;
import shz.core.NullHelp;
import shz.core.ToSet;
import shz.core.orm.entity.TreeEntity;
import shz.core.type.TypeHelp;
import shz.jdbc.generate.FieldNames;
import shz.jdbc.generate.FileTemplate;
import shz.jdbc.model.Column;
import shz.jdbc.model.Table;

public class DefaultEntityTemplate
extends FileTemplate {
    @Override
    protected String path() {
        return "api/api-" + this.info.getModuleName();
    }

    @Override
    public String packageName() {
        return this.info.getBasePackage() + ".api." + this.info.getModuleName() + ".model.entity";
    }

    @Override
    public String className() {
        return this.info.getEntityClassName();
    }

    @Override
    protected List<String> annotations() {
        LinkedList<String> annotations = new LinkedList<String>();
        annotations.add("@Getter");
        annotations.add("@Setter");
        Class<?> superEntity = this.info.getSuperEntityClass();
        if (superEntity == null || superEntity.isInterface()) {
            annotations.add("@ToString");
        } else {
            annotations.add("@ToString(callSuper = true)");
        }
        if (NullHelp.isBlank((CharSequence)this.info.getTable().getTableSchem())) {
            annotations.add("@Table(\"" + this.info.getTable().getTableName() + "\")");
        } else {
            annotations.add("@Table(value = \"" + this.info.getTable().getTableName() + "\", schema = \"" + this.info.getTable().getTableSchem() + "\")");
        }
        this.imports.add("import lombok.Getter;");
        this.imports.add("import lombok.Setter;");
        this.imports.add("import lombok.ToString;");
        this.imports.add("import shz.core.orm.annotation.Table;");
        return annotations;
    }

    @Override
    protected String classDescription() {
        String simpleName;
        String importName;
        String className = this.className();
        Class<?> superEntity = this.info.getSuperEntityClass();
        if (superEntity == null) {
            return "public class " + className;
        }
        Class enclosingClass = TypeHelp.getEnclosingClass(superEntity);
        if (enclosingClass == null) {
            importName = superEntity.getName();
            simpleName = superEntity.getSimpleName();
        } else {
            importName = enclosingClass.getName();
            String name = superEntity.getName();
            simpleName = name.substring(name.lastIndexOf(46) + 1).replace('$', '.');
        }
        this.imports.add("import " + importName + ";");
        if (TreeEntity.class.isAssignableFrom(superEntity)) {
            return "public class " + className + " implements " + simpleName + "<" + className + ">";
        }
        if (superEntity.isInterface()) {
            return "public class " + className + " implements " + simpleName;
        }
        return "public class " + className + " extends " + simpleName;
    }

    @Override
    protected List<String> content() {
        LinkedList<String> content = new LinkedList<String>();
        Class<?> superEntity = this.info.getSuperEntityClass();
        List superFields = AccessibleHelp.fields(superEntity);
        Set excludedFieldNames = ToSet.explicitCollect(superFields.stream().map(Field::getName), (int)superFields.size());
        if (superEntity != null && Serializable.class.isAssignableFrom(superEntity)) {
            content.add("    private static final long serialVersionUID = 1L;");
        }
        this.info.getTable().getColumns().forEach(column -> {
            Table table;
            String fieldName = this.fieldName((Column)column);
            if (excludedFieldNames.contains(fieldName)) {
                return;
            }
            if (NullHelp.nonBlank((CharSequence)column.getRemarks())) {
                content.add("    /**");
                content.add("     * " + column.getRemarks());
                content.add("     */");
            }
            String type = this.getType((Column)column);
            FieldNames fieldNames = this.info.getFieldNames();
            if (fieldName.equals(fieldNames.id(table = this.info.getTable()))) {
                if (!"id".equals(fieldName)) {
                    content.add("    @Id");
                    this.imports.add("import shz.core.orm.annotation.Id;");
                }
            } else if (fieldName.equals(fieldNames.delFlag(table))) {
                content.add("    @Logic");
                this.imports.add("import shz.core.orm.annotation.Logic;");
            } else if (fieldName.equals(fieldNames.version(table))) {
                content.add("    @Version");
                this.imports.add("import shz.core.orm.annotation.Version;");
            }
            content.add("    private " + type + " " + fieldName + ";");
        });
        if (superEntity != null && TreeEntity.class.isAssignableFrom(superEntity) && !excludedFieldNames.contains("children")) {
            content.add("\n    @ApiIgnore");
            content.add("    @Column(exist = false)");
            content.add("    private List<" + this.className() + "> children;");
            this.imports.add("import shz.core.net.api.ApiIgnore;");
            this.imports.add("import shz.core.orm.annotation.Column;");
            this.imports.add("import java.util.List;");
        }
        return content;
    }

    @Override
    protected boolean override() {
        return true;
    }

    @Override
    protected boolean enabled() {
        return true;
    }
}

