/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.generate.template;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import shz.core.NullHelp;
import shz.core.ToSet;
import shz.core.orm.entity.TreeEntity;
import shz.jdbc.generate.FieldNames;
import shz.jdbc.generate.FileTemplate;
import shz.jdbc.model.Column;
import shz.jdbc.model.Table;

public class DefaultUpdateVoTemplate
extends FileTemplate {
    @Override
    protected String path() {
        return "api/api-" + this.info.getModuleName();
    }

    @Override
    public String packageName() {
        return this.info.getBasePackage() + ".api." + this.info.getModuleName() + ".model.vo";
    }

    @Override
    public String className() {
        return "Update" + this.info.getTemplates().entityTemplate().className() + "Vo";
    }

    @Override
    protected List<String> annotations() {
        LinkedList<String> annotations = new LinkedList<String>();
        annotations.add("@Getter");
        annotations.add("@Setter");
        annotations.add("@ToString");
        this.imports.add("import lombok.Getter;");
        this.imports.add("import lombok.Setter;");
        this.imports.add("import lombok.ToString;");
        return annotations;
    }

    @Override
    protected String classDescription() {
        return "public class " + this.className();
    }

    @Override
    protected List<String> content() {
        LinkedList<String> content = new LinkedList<String>();
        Set<String> excludedFieldNames = this.excludedFieldNames();
        this.info.getTable().getColumns().forEach(column -> {
            Table table;
            String fieldName = this.fieldName((Column)column);
            if (excludedFieldNames.contains(fieldName)) {
                return;
            }
            if (NullHelp.nonBlank((CharSequence)column.getRemarks())) {
                content.add("    /**");
                content.add("     * " + column.getRemarks());
                content.add("     */");
            }
            String type = this.getType((Column)column);
            FieldNames fieldNames = this.info.getFieldNames();
            if (fieldName.equals(fieldNames.id(table = this.info.getTable())) || fieldName.equals(fieldNames.version(table))) {
                if ("String".equals(type)) {
                    content.add("    @NotBlank(message = \"" + column.getRemarks() + "\u4e0d\u80fd\u4e3a\u7a7a\")");
                    this.imports.add(this.info.getImports().notBlankImport());
                } else {
                    content.add("    @NotNull(message = \"" + column.getRemarks() + "\u4e0d\u80fd\u4e3a\u7a7a\")");
                    this.imports.add(this.info.getImports().notNullImport());
                }
            }
            content.add("    private " + type + " " + fieldName + ";");
        });
        return content;
    }

    protected Set<String> excludedFieldNames() {
        FieldNames fieldNames = this.info.getFieldNames();
        Table table = this.info.getTable();
        Set set = ToSet.asSet((Object[])new String[]{fieldNames.delFlag(table), fieldNames.createTime(table), fieldNames.updateTime(table), fieldNames.createBy(table), fieldNames.updateBy(table)});
        if (this.info.getSuperEntityClass() != null && TreeEntity.class.isAssignableFrom(this.info.getSuperEntityClass())) {
            set.addAll(ToSet.asSet((Object[])new String[]{"rootId", "level", "tag"}));
        }
        return set;
    }
}

