/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.handler;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import shz.core.RegexHelp;
import shz.core.StringHelp;
import shz.core.model.PageInfo;
import shz.core.orm.sql.handler.SqlHandler;
import shz.core.orm.sql.segment.Segment;
import shz.core.time.TimeHelp;

public class OracleSqlHandler
implements SqlHandler {
    public void escape(StringBuilder sb, Object val) {
        if (val == null) {
            sb.append("null");
        } else if (val instanceof Boolean || val instanceof Number) {
            sb.append(val);
        } else if (val instanceof Timestamp) {
            sb.append("TO_DATE('").append(TimeHelp.format((Timestamp)((Timestamp)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof ZonedDateTime) {
            sb.append("TO_DATE('").append(TimeHelp.format((LocalDateTime)((ZonedDateTime)val).toLocalDateTime())).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof LocalDateTime) {
            sb.append("TO_DATE('").append(TimeHelp.format((LocalDateTime)((LocalDateTime)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof Instant) {
            sb.append("TO_DATE('").append(TimeHelp.format((Instant)((Instant)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof LocalDate) {
            sb.append("TO_DATE('").append(TimeHelp.format((LocalDate)((LocalDate)val), (DateTimeFormatter)TimeHelp.DATE_PATTERN)).append("','YYYY-MM-DD')");
        } else if (val instanceof Date) {
            sb.append("TO_DATE('").append(TimeHelp.format((Date)((Date)val))).append("','YYYY-MM-DD HH24:MI:SS')");
        } else if (val instanceof LocalTime) {
            sb.append("TO_DATE('").append(TimeHelp.format((LocalTime)((LocalTime)val), (DateTimeFormatter)TimeHelp.TIME_PATTERN)).append("','HH24:MI:SS')");
        } else {
            sb.append('\'');
            String s = val.toString();
            if (!StringHelp.escape(sb::append, sb::append, (String)s, (char)'\'')) {
                sb.append(s);
            }
            sb.append('\'');
        }
    }

    public final void wrap(StringBuilder sb, Object val) {
        sb.append('\"').append(val).append('\"');
    }

    public final void page(StringBuilder sb, PageInfo<?> pageInfo) {
        sb.insert(0, "SELECT * FROM (SELECT row_.*, rownum rownum_ FROM (");
        sb.append(") row_ where rownum <=").append(pageInfo.getMax()).append(") WHERE rownum_ >=").append(pageInfo.getMin());
    }

    public final String humpToUnderline(String name) {
        return StringHelp.humpToUnderlineUpperCase((String)name);
    }

    public final String aliasToField(String name) {
        return StringHelp.underlineToHump((String)name, (boolean)false);
    }

    public List<Segment> segments(String sql) {
        sql = RegexHelp.replace((String)sql, (Pattern)Pattern.compile("(?i:SELECT)(.+?)(?i:FROM)"), matcher -> {
            String s = matcher.group(0);
            StringBuilder sb = new StringBuilder(s.length() + 50);
            sb.append(s, 0, 6);
            String selects = matcher.group(1);
            String[] arr = selects.split(",");
            for (int i = 0; i < arr.length; ++i) {
                String[] a = arr[i].trim().split("\\s+");
                if (i > 0) {
                    sb.append(',');
                } else {
                    sb.append(' ');
                }
                if (a.length == 2) {
                    sb.append(a[0]).append(' ').append(this.humpToUnderline(a[1]));
                    continue;
                }
                sb.append(arr[i]);
            }
            sb.append(s, selects.length() + 6, s.length());
            return sb.toString();
        });
        return Segment.of((String)sql);
    }
}

