/*
 * Decompiled with CFR 0.152.
 */
package shz.jdbc.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import shz.core.NullHelp;
import shz.core.PRException;
import shz.core.ToList;
import shz.jdbc.model.Column;
import shz.jdbc.model.ImportedKey;
import shz.jdbc.model.PrimaryKey;

public final class Table
implements Serializable {
    private static final long serialVersionUID = -969186504157153292L;
    private String tableCat;
    private String tableSchem;
    private String tableName;
    private String tableType;
    private String remarks;
    private String typeCat;
    private String typeSchem;
    private String typeName;
    private String selfReferencingColName;
    private String refGeneration;
    private List<PrimaryKey> primaryKeys;
    private List<ImportedKey> importedKeys;
    private List<Column> columns;

    public String getTableCat() {
        return this.tableCat;
    }

    public void setTableCat(String tableCat) {
        this.tableCat = tableCat;
    }

    public String getTableSchem() {
        return this.tableSchem;
    }

    public void setTableSchem(String tableSchem) {
        this.tableSchem = tableSchem;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getTypeCat() {
        return this.typeCat;
    }

    public void setTypeCat(String typeCat) {
        this.typeCat = typeCat;
    }

    public String getTypeSchem() {
        return this.typeSchem;
    }

    public void setTypeSchem(String typeSchem) {
        this.typeSchem = typeSchem;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getSelfReferencingColName() {
        return this.selfReferencingColName;
    }

    public void setSelfReferencingColName(String selfReferencingColName) {
        this.selfReferencingColName = selfReferencingColName;
    }

    public String getRefGeneration() {
        return this.refGeneration;
    }

    public void setRefGeneration(String refGeneration) {
        this.refGeneration = refGeneration;
    }

    public List<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(List<PrimaryKey> primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public List<ImportedKey> getImportedKeys() {
        return this.importedKeys;
    }

    public void setImportedKeys(List<ImportedKey> importedKeys) {
        this.importedKeys = importedKeys;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public String toString() {
        return "Table{tableCat='" + this.tableCat + '\'' + ", tableSchem='" + this.tableSchem + '\'' + ", tableName='" + this.tableName + '\'' + ", tableType='" + this.tableType + '\'' + ", remarks='" + this.remarks + '\'' + ", typeCat='" + this.typeCat + '\'' + ", typeSchem='" + this.typeSchem + '\'' + ", typeName='" + this.typeName + '\'' + ", selfReferencingColName='" + this.selfReferencingColName + '\'' + ", refGeneration='" + this.refGeneration + '\'' + ", primaryKeys=" + this.primaryKeys + ", importedKeys=" + this.importedKeys + ", columns=" + this.columns + '}';
    }

    public static List<Table> get(Connection conn, String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        if (conn == null) {
            return Collections.emptyList();
        }
        LinkedList result = new LinkedList();
        ResultSet tables = null;
        ResultSet primaryKeys = null;
        ResultSet importedKeys = null;
        ResultSet columns = null;
        try {
            String[] stringArray;
            catalog = NullHelp.isBlank((CharSequence)catalog) ? conn.getCatalog() : catalog;
            String string = schemaPattern = NullHelp.isBlank((CharSequence)schemaPattern) ? "%" : schemaPattern;
            if (NullHelp.isBlank((Object)types)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "TABLE";
            } else {
                stringArray = types;
            }
            types = stringArray;
            DatabaseMetaData dbMetaData = conn.getMetaData();
            tables = dbMetaData.getTables(catalog, schemaPattern, tableNamePattern, types);
            while (tables.next()) {
                Table table = new Table();
                table.setTableCat(Table.getString(tables, "TABLE_CAT"));
                table.setTableSchem(Table.getString(tables, "TABLE_SCHEM"));
                table.setTableName(Table.getString(tables, "TABLE_NAME"));
                table.setTableType(Table.getString(tables, "TABLE_TYPE"));
                table.setRemarks(Table.getString(tables, "REMARKS"));
                table.setTypeCat(Table.getString(tables, "TYPE_CAT"));
                table.setTypeSchem(Table.getString(tables, "TYPE_SCHEM"));
                table.setTypeName(Table.getString(tables, "TYPE_NAME"));
                table.setSelfReferencingColName(Table.getString(tables, "SELF_REFERENCING_COL_NAME"));
                table.setRefGeneration(Table.getString(tables, "REF_GENERATION"));
                primaryKeys = dbMetaData.getPrimaryKeys(catalog, schemaPattern, table.getTableName());
                LinkedList<PrimaryKey> primaryKeyList = new LinkedList<PrimaryKey>();
                while (primaryKeys.next()) {
                    PrimaryKey primaryKey = new PrimaryKey();
                    primaryKey.setTableCat(Table.getString(primaryKeys, "TABLE_CAT"));
                    primaryKey.setTableSchem(Table.getString(primaryKeys, "TABLE_SCHEM"));
                    primaryKey.setTableName(Table.getString(primaryKeys, "TABLE_NAME"));
                    primaryKey.setColumnName(Table.getString(primaryKeys, "COLUMN_NAME"));
                    primaryKey.setKeySeq(Table.getShort(primaryKeys, "KEY_SEQ"));
                    primaryKey.setPkName(Table.getString(primaryKeys, "PK_NAME"));
                    primaryKeyList.add(primaryKey);
                }
                table.setPrimaryKeys(primaryKeyList.isEmpty() ? Collections.emptyList() : ToList.explicitCollect(primaryKeyList.stream().distinct(), (int)primaryKeyList.size()));
                Table.close(primaryKeys);
                importedKeys = dbMetaData.getImportedKeys(catalog, schemaPattern, table.getTableName());
                LinkedList<ImportedKey> importedKeyList = new LinkedList<ImportedKey>();
                while (importedKeys.next()) {
                    ImportedKey importedKey = new ImportedKey();
                    importedKey.setPkTableCat(Table.getString(importedKeys, "PKTABLE_CAT"));
                    importedKey.setPkTableSchem(Table.getString(importedKeys, "PKTABLE_SCHEM"));
                    importedKey.setPkTableName(Table.getString(importedKeys, "PKTABLE_NAME"));
                    importedKey.setPkColumnName(Table.getString(importedKeys, "PKCOLUMN_NAME"));
                    importedKey.setPkName(Table.getString(importedKeys, "PK_NAME"));
                    importedKey.setFkTableCat(Table.getString(importedKeys, "FKTABLE_CAT"));
                    importedKey.setFkTableSchem(Table.getString(importedKeys, "FKTABLE_SCHEM"));
                    importedKey.setFkTableName(Table.getString(importedKeys, "FKTABLE_NAME"));
                    importedKey.setFkColumnName(Table.getString(importedKeys, "FKCOLUMN_NAME"));
                    importedKey.setFkName(Table.getString(importedKeys, "FK_NAME"));
                    importedKey.setKeySeq(Table.getShort(importedKeys, "KEY_SEQ"));
                    importedKey.setUpdateRule(Table.getShort(importedKeys, "UPDATE_RULE"));
                    importedKey.setDeleteRule(Table.getShort(importedKeys, "DELETE_RULE"));
                    importedKey.setDeferrability(Table.getShort(importedKeys, "DEFERRABILITY"));
                    importedKeyList.add(importedKey);
                }
                table.setImportedKeys(importedKeyList.isEmpty() ? Collections.emptyList() : ToList.explicitCollect(importedKeyList.stream().distinct(), (int)importedKeyList.size()));
                Table.close(importedKeys);
                columns = dbMetaData.getColumns(catalog, schemaPattern, table.getTableName(), "%");
                LinkedList<Column> columnList = new LinkedList<Column>();
                while (columns.next()) {
                    Column column = new Column();
                    column.setColumnName(Table.getString(columns, "COLUMN_NAME"));
                    column.setDataType(Table.getInt(columns, "DATA_TYPE"));
                    column.setTypeName(Table.getString(columns, "TYPE_NAME"));
                    column.setColumnSize(Table.getInt(columns, "COLUMN_SIZE"));
                    column.setDecimalDigits(Table.getInt(columns, "DECIMAL_DIGITS"));
                    column.setNumPrecRadix(Table.getInt(columns, "NUM_PREC_RADIX"));
                    column.setNullable(Table.getInt(columns, "NULLABLE"));
                    column.setRemarks(Table.getString(columns, "REMARKS"));
                    column.setColumnDef(Table.getString(columns, "COLUMN_DEF"));
                    column.setCharOctetLength(Table.getInt(columns, "CHAR_OCTET_LENGTH"));
                    column.setOrdinalPosition(Table.getInt(columns, "ORDINAL_POSITION"));
                    column.setIsNullable(Table.getString(columns, "IS_NULLABLE"));
                    column.setSourceDataType(Table.getShort(columns, "SOURCE_DATA_TYPE"));
                    column.setIsAutoIncrement(Table.getString(columns, "IS_AUTOINCREMENT"));
                    column.setScopeCatlog(Table.getString(columns, "SCOPE_CATLOG"));
                    column.setScopeSchem(Table.getString(columns, "SCOPE_SCHEMA"));
                    column.setScopeTable(Table.getString(columns, "SCOPE_TABLE"));
                    columnList.add(column);
                }
                table.setColumns(columnList.isEmpty() ? Collections.emptyList() : ToList.explicitCollect(columnList.stream().distinct(), (int)columnList.size()));
                Table.close(columns);
                result.add(table);
            }
        }
        catch (Throwable t) {
            try {
                throw PRException.of((Throwable)t);
            }
            catch (Throwable throwable) {
                Table.close(columns);
                Table.close(importedKeys);
                Table.close(primaryKeys);
                Table.close(tables);
                Table.close(conn);
                throw throwable;
            }
        }
        Table.close(columns);
        Table.close(importedKeys);
        Table.close(primaryKeys);
        Table.close(tables);
        Table.close(conn);
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private static String getString(ResultSet resultSet, String columnLabel) {
        try {
            return resultSet.getString(columnLabel);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private static int getInt(ResultSet resultSet, String columnLabel) {
        try {
            return resultSet.getInt(columnLabel);
        }
        catch (SQLException e) {
            return 0;
        }
    }

    private static short getShort(ResultSet resultSet, String columnLabel) {
        try {
            return resultSet.getShort(columnLabel);
        }
        catch (SQLException e) {
            return 0;
        }
    }

    private static void close(ResultSet rst) {
        if (rst != null) {
            try {
                rst.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void close(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

