/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom;

import com.siemens.sbom.standardbom.model.BomEntry;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public class BomEntrySortComparator
implements Comparator<BomEntry>,
Serializable {
    private static final long serialVersionUID = 2L;

    @Override
    public int compare(BomEntry pDto1, BomEntry pDto2) {
        int result = this.compareByNulls(pDto1, pDto2);
        if (result == 0 && pDto1 != null) {
            result = this.compareByType(pDto1, pDto2);
        }
        if (result == 0 && pDto1 != null) {
            Comparator<String> strcomp = Comparator.nullsLast(Comparator.comparing(String::toString));
            result = Objects.compare(pDto1.getGroup(), pDto2.getGroup(), strcomp);
            if (result == 0) {
                result = Objects.compare(pDto1.getName(), pDto2.getName(), strcomp);
            }
            if (result == 0) {
                result = Objects.compare(pDto1.getFilename(), pDto2.getFilename(), strcomp);
            }
            if (result == 0) {
                result = Objects.compare(pDto1.getVersion(), pDto2.getVersion(), strcomp);
            }
            if (result == 0) {
                result = Objects.compare(pDto1.getSha1(), pDto2.getSha1(), strcomp);
            }
        }
        if (result == 0 && pDto1 != null) {
            result = this.compareByIdentity(pDto1, pDto2);
        }
        return result;
    }

    private int compareByNulls(Object pDto1, Object pDto2) {
        int result = 0;
        if (pDto1 == null && pDto2 != null) {
            result = 1;
        } else if (pDto1 != null && pDto2 == null) {
            result = -1;
        }
        return result;
    }

    private int compareByType(BomEntry pDto1, BomEntry pDto2) {
        int typeOrder1 = pDto1.getType() != null ? pDto1.getType().ordinal() : Integer.MAX_VALUE;
        int typeOrder2 = pDto2.getType() != null ? pDto2.getType().ordinal() : Integer.MAX_VALUE;
        return Integer.compare(typeOrder1, typeOrder2);
    }

    private int compareByIdentity(Object pDto1, Object pDto2) {
        int hash2;
        int result = 0;
        int hash1 = System.identityHashCode(pDto1);
        if (hash1 < (hash2 = System.identityHashCode(pDto2))) {
            result = -1;
        } else if (hash1 > hash2) {
            result = 1;
        }
        return result;
    }
}

