/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom;

import com.siemens.sbom.standardbom.StandardBomException;
import com.siemens.sbom.standardbom.internal.CustomPropertySorter;
import com.siemens.sbom.standardbom.model.BomEntry;
import com.siemens.sbom.standardbom.model.StandardBom;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.cyclonedx.Version;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.exception.ParseException;
import org.cyclonedx.generators.BomGeneratorFactory;
import org.cyclonedx.generators.json.BomJsonGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.parsers.BomParserFactory;
import org.cyclonedx.parsers.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBomParser {
    private static final Logger LOG = LoggerFactory.getLogger(StandardBomParser.class);
    private static final int BUFFER_SIZE_BYTES = 8192;
    private static final String NEWLINE_TOKEN = "\u00a7LINEBREAK\u00a7";

    /*
     * Exception decompiling
     */
    public StandardBom parse(File pJsonFile) throws IOException, ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public StandardBom parse(InputStream pJsonStream) throws IOException, ParseException {
        byte[] jsonBytes = this.toByteArray(pJsonStream);
        Parser jsonParser = BomParserFactory.createParser((byte[])jsonBytes);
        Bom bom = jsonParser.parse(jsonBytes);
        StandardBom result = new StandardBom(bom);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully parsed Standard BOM");
        }
        return result;
    }

    private byte[] toByteArray(InputStream pJsonStream) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(43008);
        long count = 0L;
        while (-1 != (n = pJsonStream.read(buffer))) {
            baos.write(buffer, 0, n);
            count += (long)n;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("toByteArray() - read " + count + " bytes from stream");
        }
        return baos.toByteArray();
    }

    public void save(@Nonnull StandardBom pBom, @Nonnull File pOutputFile) throws IOException {
        try {
            byte[] jsonBytes = this.stringify(pBom).getBytes(StandardCharsets.UTF_8);
            Files.write(pOutputFile.toPath(), jsonBytes, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            LOG.debug("BOM stored in file: " + pOutputFile);
        }
        catch (StandardBomException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new StandardBomException("Failed to write output file: " + pOutputFile, e);
        }
    }

    @Nonnull
    public String stringify(@Nonnull StandardBom pBom) {
        this.escapeComponentFields(pBom, BomEntry::getCopyright, BomEntry::setCopyright);
        this.escapeComponentFields(pBom, BomEntry::getThirdPartyNotices, BomEntry::setThirdPartyNotices);
        this.escapeExtRefPurls(pBom);
        this.sortCustomProperties(pBom);
        String json = null;
        try {
            Bom cycloneDxBom = pBom.getCycloneDxBom();
            BomJsonGenerator generator = BomGeneratorFactory.createJson((Version)Version.VERSION_16, (Bom)cycloneDxBom);
            json = generator.toJsonString();
        }
        catch (RuntimeException | GeneratorException e) {
            throw new StandardBomException("Failed to convert output to JSON", e);
        }
        json = this.unescapeComponentFields(json);
        json = this.unescapeExtRefPurls(json);
        json = this.removeEmptyServicesMetadata(json);
        json = this.injectSchemaSpec(json);
        return json.concat(System.lineSeparator());
    }

    @Nonnull
    private String injectSchemaSpec(@Nonnull String pJson) {
        String schemaAttribute = "  \"$schema\": \"http://cyclonedx.org/schema/bom-1.6.schema.json\",".concat(System.lineSeparator());
        if (pJson.contains("\"$schema\"")) {
            return pJson;
        }
        String insertMarker = '{' + System.lineSeparator();
        int insertPosition = pJson.indexOf(insertMarker) + insertMarker.length();
        StringBuilder sb = new StringBuilder(pJson);
        sb.insert(insertPosition, schemaAttribute);
        return sb.toString();
    }

    private void escapeExtRefPurls(@Nonnull StandardBom pBom) {
        if (pBom.getCycloneDxBom().getExternalReferences() != null) {
            for (ExternalReference extRef : pBom.getCycloneDxBom().getExternalReferences()) {
                String purl = extRef.getUrl();
                if (purl == null || !purl.startsWith("pkg:")) continue;
                purl = "http://PURL-ESCAPE/" + purl.substring("pkg:".length());
                extRef.setUrl(purl);
            }
        }
    }

    private String unescapeExtRefPurls(@Nonnull String pJson) {
        return pJson.replaceAll(Pattern.quote("http://PURL-ESCAPE/"), "pkg:");
    }

    private void escapeComponentFields(@Nonnull StandardBom pBom, @Nonnull Function<BomEntry, String> pGetter, @Nonnull BiConsumer<BomEntry, String> pSetter) {
        for (BomEntry bomEntry : pBom.getComponents()) {
            String value = pGetter.apply(bomEntry);
            if (value == null) continue;
            value = value.replaceAll("\r?\n", NEWLINE_TOKEN);
            pSetter.accept(bomEntry, value);
        }
    }

    @Nonnull
    private String unescapeComponentFields(@Nonnull String pJson) {
        return pJson.replaceAll(NEWLINE_TOKEN, Matcher.quoteReplacement("\\n"));
    }

    @Nonnull
    private String removeEmptyServicesMetadata(@Nonnull String pJson) {
        return pJson.replaceFirst(Pattern.quote("]," + System.lineSeparator() + "      \"services\" : [ ]"), "]");
    }

    private void sortCustomProperties(@Nonnull StandardBom pBom) {
        pBom.getComponents().stream().map(c -> c.getCycloneDxComponent().getProperties()).filter(Objects::nonNull).forEach(customPropsList -> customPropsList.sort(CustomPropertySorter.INSTANCE));
    }
}

