/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.ExternalReference;

public class ExtRefProcessor {
    private final Supplier<List<ExternalReference>> extRefSupplier;
    private final Consumer<ExternalReference> extRefAdder;

    public ExtRefProcessor(@Nonnull Supplier<List<ExternalReference>> pExtRefSupplier, @Nonnull Consumer<ExternalReference> pExtRefAdder) {
        this.extRefSupplier = Objects.requireNonNull(pExtRefSupplier, "external references list supplier was null");
        this.extRefAdder = Objects.requireNonNull(pExtRefAdder, "external references adder was null");
    }

    @CheckForNull
    public String get(@Nonnull Predicate<ExternalReference> pPredicate) {
        ExternalReference ref;
        if (this.extRefSupplier.get() != null && (ref = (ExternalReference)this.extRefSupplier.get().stream().filter(pPredicate).findFirst().orElse(null)) != null) {
            return ref.getUrl();
        }
        return null;
    }

    public void set(@Nonnull Predicate<ExternalReference> pPredicate, @Nullable String pUrl, @Nonnull Consumer<ExternalReference> pSetValue) {
        if (this.extRefSupplier.get() != null) {
            this.extRefSupplier.get().removeIf(pPredicate);
        }
        if (pUrl != null && !pUrl.trim().isEmpty()) {
            ExternalReference extRef = new ExternalReference();
            extRef.setUrl(pUrl.trim());
            pSetValue.accept(extRef);
            this.extRefAdder.accept(extRef);
        }
    }
}

