/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public final class FileProtocolHandler {
    private static final Pattern FILE_PROT_PATTERN = Pattern.compile("file:/{0,3}(.+)", 2);

    private FileProtocolHandler() {
    }

    @CheckForNull
    public static String ensureFileProtocol(@Nullable String pRelativePath) {
        Matcher m;
        if (pRelativePath != null && !(m = FILE_PROT_PATTERN.matcher(pRelativePath)).matches()) {
            return "file:///" + pRelativePath;
        }
        return pRelativePath;
    }

    @CheckForNull
    public static String withoutFileProtocol(@Nullable String pRelativePath) {
        Matcher m;
        if (pRelativePath != null && (m = FILE_PROT_PATTERN.matcher(pRelativePath)).matches()) {
            return m.group(1);
        }
        return pRelativePath;
    }
}

