/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import com.siemens.sbom.standardbom.internal.ListProcessor;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.Hash;

public class HashProcessor {
    private static final Map<Hash.Algorithm, Pattern> PATTERNS = HashProcessor.buildPatterns();
    private final Supplier<List<Hash>> hashesSupplier;
    private final Consumer<Hash> hashAdder;

    public HashProcessor(@Nonnull Supplier<List<Hash>> pHashesSupplier, @Nonnull Consumer<Hash> pAdder) {
        this.hashesSupplier = Objects.requireNonNull(pHashesSupplier, "hashes supplier is required");
        this.hashAdder = Objects.requireNonNull(pAdder, "hashes adder is required");
    }

    @Nonnull
    private static Map<Hash.Algorithm, Pattern> buildPatterns() {
        EnumMap<Hash.Algorithm, Pattern> result = new EnumMap<Hash.Algorithm, Pattern>(Hash.Algorithm.class);
        result.put(Hash.Algorithm.MD5, Pattern.compile("[A-Fa-f0-9]{32}"));
        result.put(Hash.Algorithm.SHA1, Pattern.compile("[A-Fa-f0-9]{40}"));
        result.put(Hash.Algorithm.SHA_256, Pattern.compile("[A-Fa-f0-9]{64}"));
        result.put(Hash.Algorithm.SHA_512, Pattern.compile("[A-Fa-f0-9]{128}"));
        return result;
    }

    @CheckForNull
    public String get(@Nonnull Hash.Algorithm pAlgorithm) {
        return ListProcessor.HASH.first(this.hashesSupplier.get(), pAlgorithm.getSpec());
    }

    public void set(@Nonnull Hash.Algorithm pAlgorithm, @Nullable String pHash) {
        ListProcessor.HASH.removeAll(this.hashesSupplier.get(), pAlgorithm.getSpec());
        if (pHash != null) {
            if (PATTERNS.containsKey(pAlgorithm) && !PATTERNS.get(pAlgorithm).matcher(pHash).matches()) {
                throw new IllegalArgumentException("value is not a valid " + pAlgorithm.getSpec() + " hash: " + pHash);
            }
            this.hashAdder.accept(new Hash(pAlgorithm, pHash.toLowerCase(Locale.ROOT)));
        }
    }
}

