/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.Property;

public class ListProcessor<T> {
    public static final ListProcessor<Hash> HASH = new ListProcessor<Hash>(Hash::getAlgorithm, Hash::getValue);
    public static final ListProcessor<Property> PROPERTY = new ListProcessor<Property>(Property::getName, Property::getValue);
    private final Function<T, String> keySelector;
    private final Function<T, String> valueSelector;

    public ListProcessor(@Nonnull Function<T, String> pKeySelector, @Nonnull Function<T, String> pValueSelector) {
        this.keySelector = Objects.requireNonNull(pKeySelector, "key selector is required");
        this.valueSelector = Objects.requireNonNull(pValueSelector, "value selector is required");
    }

    @CheckForNull
    public String first(@Nullable List<T> pList, @Nonnull String pKey) {
        Object elem;
        String result = null;
        if (pList != null && (elem = pList.stream().filter(t -> pKey.equals(this.keySelector.apply(t))).findFirst().orElse(null)) != null) {
            result = this.valueSelector.apply(elem);
        }
        return result;
    }

    public void removeAll(@Nullable List<T> pList, @Nonnull String pKey) {
        if (pList != null) {
            pList.removeIf(elem -> pKey.equals(this.keySelector.apply(elem)));
        }
    }
}

