/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import com.siemens.sbom.standardbom.internal.ListProcessor;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.Property;

public class PropertyProcessor {
    private final Supplier<List<Property>> propertySupplier;
    private final Consumer<Property> propertyAdder;

    public PropertyProcessor(@Nonnull Supplier<List<Property>> pPropertySupplier, @Nonnull Consumer<Property> pPropertyAdder) {
        this.propertySupplier = Objects.requireNonNull(pPropertySupplier, "property supplier was null");
        this.propertyAdder = Objects.requireNonNull(pPropertyAdder, "property adder was null");
    }

    @CheckForNull
    public String get(@Nonnull String pKey) {
        return ListProcessor.PROPERTY.first(this.propertySupplier.get(), this.namespacedKey(pKey));
    }

    public void set(@Nonnull String pKey, @Nullable String pValue) {
        String key = this.namespacedKey(pKey);
        ListProcessor.PROPERTY.removeAll(this.propertySupplier.get(), key);
        if (pValue != null && !pValue.trim().isEmpty()) {
            Property prop = new Property();
            prop.setName(key);
            prop.setValue(pValue.trim());
            this.propertyAdder.accept(prop);
        }
    }

    @Nonnull
    private String namespacedKey(@Nonnull String pKey) {
        String result = pKey;
        if (!pKey.contains(":")) {
            result = "siemens:" + pKey;
        }
        return result;
    }
}

