/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringMapProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(StringMapProcessor.class);
    private final Supplier<String> stringSupplier;
    private final Consumer<String> stringChange;

    public StringMapProcessor(@Nonnull Supplier<String> pStringSupplier, @Nonnull Consumer<String> pStringChange) {
        this.stringSupplier = Objects.requireNonNull(pStringSupplier);
        this.stringChange = Objects.requireNonNull(pStringChange);
    }

    @Nonnull
    private Properties loadProps() {
        SortedProperties props = new SortedProperties();
        if (this.stringSupplier.get() != null) {
            try (StringReader sr = new StringReader(this.stringSupplier.get());){
                props.load(sr);
            }
            catch (IOException | RuntimeException e) {
                LOG.warn("Comment is not recognized as encoded by standard-bom: " + this.stringSupplier.get());
            }
        }
        return props;
    }

    @CheckForNull
    private String serializeProps(@Nonnull Properties pProps) {
        if (pProps.isEmpty()) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            pProps.store(sw, null);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalArgumentException("value fails to serialize", e);
        }
        String s = sw.toString();
        s = s.substring(s.indexOf(10) + 1).replaceAll("\r", "");
        if (s.endsWith("\n")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    @CheckForNull
    public String get(@Nonnull String pKey) {
        Properties props = this.loadProps();
        return props.getProperty(pKey);
    }

    public void set(@Nonnull String pKey, @Nullable String pValue) {
        Properties props = this.loadProps();
        props.remove(pKey);
        if (pValue != null && !pValue.trim().isEmpty()) {
            props.setProperty(pKey, pValue.trim());
        }
        this.stringChange.accept(this.serializeProps(props));
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        @Nonnull
        public synchronized Enumeration<Object> keys() {
            ArrayList<Object> keyList = Collections.list(super.keys());
            keyList.sort(Comparator.comparing(Object::toString));
            return Collections.enumeration(keyList);
        }

        @Override
        @Nonnull
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.synchronizedSet(super.entrySet().stream().sorted(Comparator.comparing(e -> e.getKey().toString())).collect(Collectors.toCollection(LinkedHashSet::new)));
        }
    }
}

