/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.internal;

import com.siemens.sbom.standardbom.StandardBomException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class VersionUtil {
    private static final String VERSION_FILENAME = "/standard-bom-version.properties";
    private static final Properties VERSION_PROPS = VersionUtil.readProperties("/standard-bom-version.properties");

    private VersionUtil() {
    }

    static Properties readProperties(String pVersionFile) {
        Properties props = new Properties();
        try (InputStream is = VersionUtil.class.getResourceAsStream(pVersionFile);){
            if (is == null) {
                throw new FileNotFoundException("Version file not found: " + pVersionFile);
            }
            props.load(is);
        }
        catch (IOException | RuntimeException e) {
            throw new StandardBomException("Bug: Failed to load version information file: " + pVersionFile, e);
        }
        return props;
    }

    public static String getSpecName() {
        return VERSION_PROPS.getProperty("specName");
    }

    public static String getSpecVersion() {
        return VERSION_PROPS.getProperty("specVersion");
    }

    public static String getSpecWebsite() {
        return VERSION_PROPS.getProperty("specWebsite");
    }

    public static String getLibraryGroup() {
        return VERSION_PROPS.getProperty("libGroup");
    }

    public static String getLibraryName() {
        return VERSION_PROPS.getProperty("libName");
    }

    public static String getLibraryVersion() {
        return VERSION_PROPS.getProperty("libVersion");
    }

    public static String getLibraryDescription() {
        return VERSION_PROPS.getProperty("libDescription");
    }

    public static String getLibraryWebsite() {
        return VERSION_PROPS.getProperty("libWebsite");
    }
}

