/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.model;

import com.siemens.sbom.standardbom.internal.HashProcessor;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;

public abstract class AbstractSourceArtifactRef {
    private final HashProcessor hashProc;
    private final ExternalReference cycloneDxRef;

    protected AbstractSourceArtifactRef() {
        this(new ExternalReference(), ExternalReference.Type.DISTRIBUTION);
    }

    protected AbstractSourceArtifactRef(@Nonnull ExternalReference pCycloneDxRef, @Nonnull ExternalReference.Type pRefType) {
        this.cycloneDxRef = Objects.requireNonNull(pCycloneDxRef, "the CycloneDX delegate was null");
        this.cycloneDxRef.setType(Objects.requireNonNull(pRefType, "the external reference type was null"));
        this.hashProc = new HashProcessor(() -> ((ExternalReference)this.cycloneDxRef).getHashes(), arg_0 -> ((ExternalReference)this.cycloneDxRef).addHash(arg_0));
    }

    public static boolean isSourceReference(@Nullable ExternalReference pExternalReference) {
        boolean result = pExternalReference != null && (pExternalReference.getType() == ExternalReference.Type.SOURCE_DISTRIBUTION || pExternalReference.getType() == ExternalReference.Type.DISTRIBUTION && "source archive (local copy)".equals(pExternalReference.getComment()));
        return result;
    }

    public String getUrl() {
        return this.cycloneDxRef.getUrl();
    }

    public void setUrl(String pUrl) {
        this.cycloneDxRef.setUrl(pUrl);
    }

    @CheckForNull
    public String getMd5() {
        return this.hashProc.get(Hash.Algorithm.MD5);
    }

    public void setMd5(@Nullable String pMd5) {
        this.hashProc.set(Hash.Algorithm.MD5, pMd5);
    }

    @CheckForNull
    public String getSha1() {
        return this.hashProc.get(Hash.Algorithm.SHA1);
    }

    public void setSha1(@Nullable String pSha1) {
        this.hashProc.set(Hash.Algorithm.SHA1, pSha1);
    }

    @CheckForNull
    public String getSha256() {
        return this.hashProc.get(Hash.Algorithm.SHA_256);
    }

    public void setSha256(@Nullable String pSha256) {
        this.hashProc.set(Hash.Algorithm.SHA_256, pSha256);
    }

    @CheckForNull
    public String getSha512() {
        return this.hashProc.get(Hash.Algorithm.SHA_512);
    }

    public void setSha512(@Nullable String pSha512) {
        this.hashProc.set(Hash.Algorithm.SHA_512, pSha512);
    }

    @Nonnull
    public ExternalReference getCycloneDxRef() {
        return this.cycloneDxRef;
    }
}

