/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.model;

import com.siemens.sbom.standardbom.internal.ExtRefProcessor;
import com.siemens.sbom.standardbom.internal.FileProtocolHandler;
import com.siemens.sbom.standardbom.internal.HashProcessor;
import com.siemens.sbom.standardbom.internal.PropertyProcessor;
import com.siemens.sbom.standardbom.model.AbstractSourceArtifactRef;
import com.siemens.sbom.standardbom.model.SourceArtifactRefLocal;
import com.siemens.sbom.standardbom.model.SourceArtifactRefUrl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.OrganizationalContact;

@NotThreadSafe
public class BomEntry {
    public static final String RELATIVE_PATH = "relativePath";
    private static final Predicate<ExternalReference> TYPE_RELATIVE_PATH = r -> ExternalReference.Type.DISTRIBUTION.equals((Object)r.getType()) && RELATIVE_PATH.equals(r.getComment());
    private static final Predicate<ExternalReference> TYPE_WEBSITE = r -> ExternalReference.Type.WEBSITE.equals((Object)r.getType());
    private static final Predicate<ExternalReference> TYPE_VCS = r -> ExternalReference.Type.VCS.equals((Object)r.getType());
    private final HashProcessor hashProc;
    private final PropertyProcessor propertyProc;
    private final ExtRefProcessor extRefProc;
    private final Component cycloneDxComponent;

    public BomEntry() {
        this(new Component());
    }

    public BomEntry(@Nonnull Component pCycloneDxComponent) {
        this.cycloneDxComponent = Objects.requireNonNull(pCycloneDxComponent, "CycloneDX Component must not be null");
        this.hashProc = new HashProcessor(() -> ((Component)this.cycloneDxComponent).getHashes(), arg_0 -> ((Component)this.cycloneDxComponent).addHash(arg_0));
        this.propertyProc = new PropertyProcessor(() -> ((Component)this.cycloneDxComponent).getProperties(), arg_0 -> ((Component)this.cycloneDxComponent).addProperty(arg_0));
        this.extRefProc = new ExtRefProcessor(() -> ((Component)this.cycloneDxComponent).getExternalReferences(), arg_0 -> ((Component)this.cycloneDxComponent).addExternalReference(arg_0));
    }

    @CheckForNull
    public String getBomRef() {
        return this.cycloneDxComponent.getBomRef();
    }

    public void setBomRef(@Nullable String pBomRef) {
        this.cycloneDxComponent.setBomRef(pBomRef);
    }

    public Component.Type getType() {
        return this.cycloneDxComponent.getType();
    }

    public void setType(Component.Type pType) {
        this.cycloneDxComponent.setType(pType);
    }

    public String getGroup() {
        return this.cycloneDxComponent.getGroup();
    }

    public void setGroup(String pGroup) {
        this.cycloneDxComponent.setGroup(pGroup);
    }

    public String getName() {
        return this.cycloneDxComponent.getName();
    }

    public void setName(String pName) {
        this.cycloneDxComponent.setName(pName);
    }

    public String getVersion() {
        return this.cycloneDxComponent.getVersion();
    }

    public void setVersion(String pVersion) {
        this.cycloneDxComponent.setVersion(pVersion);
    }

    public String getPurl() {
        return this.cycloneDxComponent.getPurl();
    }

    public void setPurl(String pPurl) {
        this.cycloneDxComponent.setPurl(pPurl);
    }

    public void addAuthor(@Nullable String pName, @Nullable String pEmail) {
        if (pName != null || pEmail != null) {
            OrganizationalContact author = new OrganizationalContact();
            author.setName(pName);
            author.setEmail(pEmail);
            this.getAuthors().add(author);
        }
    }

    public void addAuthor(@Nullable String pName) {
        this.addAuthor(pName, null);
    }

    @Nonnull
    public List<OrganizationalContact> getAuthors() {
        ArrayList authors = this.cycloneDxComponent.getAuthors();
        if (authors == null) {
            authors = new ArrayList();
            this.cycloneDxComponent.setAuthors(authors);
        }
        return authors;
    }

    public void setAuthors(@Nullable List<OrganizationalContact> pNewAuthors) {
        this.cycloneDxComponent.setAuthors((List)(pNewAuthors != null ? new ArrayList<OrganizationalContact>(pNewAuthors) : null));
    }

    public String getDescription() {
        return this.cycloneDxComponent.getDescription();
    }

    public void setDescription(String pDescription) {
        this.cycloneDxComponent.setDescription(pDescription);
    }

    @CheckForNull
    public String getPrimaryLanguage() {
        return this.propertyProc.get("primaryLanguage");
    }

    public void setPrimaryLanguage(@Nullable String pPrimaryLanguage) {
        this.propertyProc.set("primaryLanguage", pPrimaryLanguage);
    }

    @CheckForNull
    public Boolean isDirectDependency() {
        String v = this.propertyProc.get("direct");
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return null;
    }

    public void setDirectDependency(@Nullable Boolean pDirect) {
        this.propertyProc.set("direct", pDirect != null ? Boolean.toString(pDirect) : null);
    }

    @CheckForNull
    public String getLegalRemark() {
        return this.propertyProc.get("legalRemark");
    }

    public void setLegalRemark(@Nullable String pLegalRemark) {
        this.propertyProc.set("legalRemark", pLegalRemark);
    }

    @CheckForNull
    public String getFilename() {
        return this.propertyProc.get("filename");
    }

    public void setFilename(@Nullable String pFilename) {
        this.propertyProc.set("filename", pFilename);
    }

    @CheckForNull
    public String getWebsite() {
        return this.extRefProc.get(TYPE_WEBSITE);
    }

    public void setWebsite(@Nullable String pWebsite) {
        this.extRefProc.set(TYPE_WEBSITE, pWebsite, ref -> ref.setType(ExternalReference.Type.WEBSITE));
    }

    @CheckForNull
    public String getRepoUrl() {
        return this.extRefProc.get(TYPE_VCS);
    }

    public void setRepoUrl(@Nullable String pRepoUrl) {
        this.extRefProc.set(TYPE_VCS, pRepoUrl, ref -> ref.setType(ExternalReference.Type.VCS));
    }

    @CheckForNull
    public String getRelativePath() {
        return FileProtocolHandler.withoutFileProtocol(this.extRefProc.get(TYPE_RELATIVE_PATH));
    }

    public void setRelativePath(@Nullable String pRelativePath) {
        String relativePath = pRelativePath;
        if (relativePath != null && !relativePath.contains(":")) {
            relativePath = relativePath.replaceAll(Pattern.quote("\\"), "/");
            relativePath = FileProtocolHandler.ensureFileProtocol(relativePath);
        }
        this.extRefProc.set(TYPE_RELATIVE_PATH, relativePath, ref -> {
            ref.setType(ExternalReference.Type.DISTRIBUTION);
            ref.setComment(RELATIVE_PATH);
        });
    }

    @Nonnull
    public LicenseChoice getLicenses() {
        LicenseChoice licenses = this.cycloneDxComponent.getLicenses();
        if (licenses == null) {
            licenses = new LicenseChoice();
            this.cycloneDxComponent.setLicenses(licenses);
        }
        return licenses;
    }

    public void addLicense(License pLicense) {
        this.getLicenses().addLicense(pLicense);
    }

    @CheckForNull
    public String getCopyright() {
        return this.cycloneDxComponent.getCopyright();
    }

    public void setCopyright(@Nullable String pCopyright) {
        this.cycloneDxComponent.setCopyright(pCopyright);
    }

    public void addCopyright(@Nullable String pCopyright) {
        if (pCopyright != null) {
            String previousStatements = this.cycloneDxComponent.getCopyright();
            previousStatements = previousStatements != null && !previousStatements.trim().isEmpty() ? previousStatements + "\n" : "";
            this.cycloneDxComponent.setCopyright(previousStatements + pCopyright.trim());
        }
    }

    @CheckForNull
    public String getCpe() {
        return this.cycloneDxComponent.getCpe();
    }

    public void setCpe(@Nullable String pCpeName) {
        this.cycloneDxComponent.setCpe(pCpeName);
    }

    @CheckForNull
    public Component.Scope getScope() {
        return this.cycloneDxComponent.getScope();
    }

    public void setScope(@Nullable Component.Scope pScope) {
        this.cycloneDxComponent.setScope(pScope);
    }

    @CheckForNull
    public Boolean isInternal() {
        String v = this.propertyProc.get("internal");
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return null;
    }

    public void setInternal(@Nullable Boolean pValue) {
        this.propertyProc.set("internal", pValue != null ? pValue.toString() : null);
    }

    @CheckForNull
    public String getThirdPartyNotices() {
        return this.propertyProc.get("thirdPartyNotices");
    }

    public void setThirdPartyNotices(@Nullable String pThirdPartyNotices) {
        this.propertyProc.set("thirdPartyNotices", pThirdPartyNotices);
    }

    public void addThirdPartyNotice(@Nullable String pThirdPartyNotice) {
        if (pThirdPartyNotice != null) {
            String previousNotices = this.getThirdPartyNotices();
            previousNotices = previousNotices != null && !previousNotices.trim().isEmpty() ? previousNotices + "\n\n" : "";
            this.setThirdPartyNotices(previousNotices + pThirdPartyNotice.trim());
        }
    }

    @Nonnull
    public List<AbstractSourceArtifactRef> getSources() {
        ArrayList<AbstractSourceArtifactRef> sources = new ArrayList<AbstractSourceArtifactRef>();
        if (this.cycloneDxComponent.getExternalReferences() != null) {
            for (ExternalReference ref : this.cycloneDxComponent.getExternalReferences()) {
                if (SourceArtifactRefLocal.isSourceReference(ref)) {
                    sources.add(new SourceArtifactRefLocal(ref));
                    continue;
                }
                if (!SourceArtifactRefUrl.isSourceReference(ref)) continue;
                sources.add(new SourceArtifactRefUrl(ref));
            }
        }
        return Collections.unmodifiableList(sources);
    }

    public void addSources(@Nonnull AbstractSourceArtifactRef pSourceArtifactRef) {
        this.cycloneDxComponent.addExternalReference(pSourceArtifactRef.getCycloneDxRef());
    }

    public boolean hasSourceArchives() {
        return !this.findSourceArchives().isEmpty();
    }

    @Nonnull
    public Set<String> getSourceArchives() {
        return this.findSourceArchives();
    }

    @Nonnull
    private Set<String> findSourceArchives() {
        Set result = this.getSources().stream().filter(SourceArtifactRefLocal.class::isInstance).map(SourceArtifactRefLocal.class::cast).map(SourceArtifactRefLocal::getRelativePath).collect(Collectors.toSet());
        return Collections.unmodifiableSet(result);
    }

    public boolean hasSourceDownloadUrls() {
        return !this.findSourceDownloadUrls().isEmpty();
    }

    @Nonnull
    public Set<String> getSourceDownloadUrls() {
        return this.findSourceDownloadUrls();
    }

    @Nonnull
    private Set<String> findSourceDownloadUrls() {
        Set result = this.getSources().stream().filter(SourceArtifactRefUrl.class::isInstance).map(SourceArtifactRefUrl.class::cast).map(AbstractSourceArtifactRef::getUrl).collect(Collectors.toSet());
        return Collections.unmodifiableSet(result);
    }

    @CheckForNull
    public String getMd5() {
        return this.hashProc.get(Hash.Algorithm.MD5);
    }

    public void setMd5(@Nullable String pMd5) {
        this.hashProc.set(Hash.Algorithm.MD5, pMd5);
    }

    @CheckForNull
    public String getSha1() {
        return this.hashProc.get(Hash.Algorithm.SHA1);
    }

    public void setSha1(@Nullable String pSha1) {
        this.hashProc.set(Hash.Algorithm.SHA1, pSha1);
    }

    @CheckForNull
    public String getSha256() {
        return this.hashProc.get(Hash.Algorithm.SHA_256);
    }

    public void setSha256(@Nullable String pSha256) {
        this.hashProc.set(Hash.Algorithm.SHA_256, pSha256);
    }

    @CheckForNull
    public String getSha512() {
        return this.hashProc.get(Hash.Algorithm.SHA_512);
    }

    public void setSha512(@Nullable String pSha512) {
        this.hashProc.set(Hash.Algorithm.SHA_512, pSha512);
    }

    @Nonnull
    public Component getCycloneDxComponent() {
        return this.cycloneDxComponent;
    }
}

