/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.model;

import com.siemens.sbom.standardbom.StandardBomUtil;
import com.siemens.sbom.standardbom.internal.StringMapProcessor;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;

public class ExternalComponent {
    public static final Pattern BLACKDUCK_COMPONENT_ID_PATTERN = Pattern.compile("\\d{1,12}");
    public static final Pattern SW360_ID_PATTERN = Pattern.compile("[0-9a-fA-F]{32}");
    private static final Pattern PURL_PATTERN = Pattern.compile("pkg:[a-z]+/.+");
    public static final String UNKNOWN_PURL = "pkg:generic/com.siemens.scp/no-purl";
    private final ExternalReference cycloneDxRef;
    private final StringMapProcessor stringMapProc;

    public ExternalComponent() {
        this(new ExternalReference());
    }

    public ExternalComponent(@Nonnull ExternalReference pCycloneDxRef) {
        this.cycloneDxRef = Objects.requireNonNull(pCycloneDxRef, "CycloneDX delegate was null");
        this.cycloneDxRef.setType(ExternalReference.Type.OTHER);
        this.cycloneDxRef.setUrl(UNKNOWN_PURL);
        this.stringMapProc = new StringMapProcessor(() -> ((ExternalReference)this.cycloneDxRef).getComment(), arg_0 -> ((ExternalReference)this.cycloneDxRef).setComment(arg_0));
    }

    public static boolean isExternalComponent(@Nullable ExternalReference pExtRef) {
        boolean result = pExtRef != null && pExtRef.getType() == ExternalReference.Type.OTHER && pExtRef.getUrl() != null && PURL_PATTERN.matcher(pExtRef.getUrl()).matches() && ExternalComponent.canBeDeserializedAsProperties(pExtRef.getComment());
        return result;
    }

    private static boolean canBeDeserializedAsProperties(@Nullable String pSerialized) {
        boolean result = true;
        if (pSerialized != null) {
            result = false;
            try (StringReader sr = new StringReader(pSerialized);){
                new Properties().load(sr);
                result = true;
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        }
        return result;
    }

    @CheckForNull
    public String getExternalId() {
        return this.stringMapProc.get("ExternalId");
    }

    public void setExternalId(@Nullable String pExternalId, @Nullable Pattern pValidationPattern) {
        if (pExternalId != null && pValidationPattern != null && !pValidationPattern.matcher(pExternalId).matches()) {
            throw new IllegalArgumentException("ExternalId \"" + pExternalId + "\" does not match the validation pattern: " + pValidationPattern.pattern());
        }
        this.stringMapProc.set("ExternalId", pExternalId);
    }

    public void setExternalId(@Nullable String pExternalId) {
        this.setExternalId(pExternalId, null);
    }

    @Deprecated
    public String getPurl() {
        return this.getUrl();
    }

    @Deprecated
    public void setPurl(String pPurl) {
        this.setUrl(pPurl);
    }

    public String getUrl() {
        return this.cycloneDxRef.getUrl();
    }

    public void setUrl(@Nullable String pPurl) {
        if (pPurl != null && !PURL_PATTERN.matcher(pPurl).matches()) {
            throw new IllegalArgumentException("value is not a purl: " + pPurl);
        }
        this.cycloneDxRef.setUrl(pPurl);
    }

    @CheckForNull
    public String getLegalRemark() {
        return this.stringMapProc.get("LegalRemark");
    }

    public void setLegalRemark(@Nullable String pLegalRemark) {
        this.stringMapProc.set("LegalRemark", pLegalRemark);
    }

    @CheckForNull
    public Component.Type getType() {
        String s = this.stringMapProc.get("Type");
        return StandardBomUtil.string2compType(s);
    }

    public void setType(@Nullable Component.Type pType) {
        this.stringMapProc.set("Type", pType != null ? pType.getTypeName() : null);
    }

    @CheckForNull
    public String getDescription() {
        return this.stringMapProc.get("Description");
    }

    public void setDescription(@Nullable String pDescription) {
        this.stringMapProc.set("Description", pDescription);
    }

    @Nonnull
    public ExternalReference getCycloneDxRef() {
        return this.cycloneDxRef;
    }
}

