/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.model;

import com.siemens.sbom.standardbom.internal.FileProtocolHandler;
import com.siemens.sbom.standardbom.model.AbstractSourceArtifactRef;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.ExternalReference;

public class SourceArtifactRefLocal
extends AbstractSourceArtifactRef {
    public static final String SOURCE_ARCHIVE_LOCAL = "source archive (local copy)";

    public SourceArtifactRefLocal() {
        this(new ExternalReference());
    }

    public SourceArtifactRefLocal(@Nonnull ExternalReference pExternalReference) {
        super(pExternalReference, ExternalReference.Type.DISTRIBUTION);
        pExternalReference.setComment(SOURCE_ARCHIVE_LOCAL);
    }

    @CheckForNull
    public String getRelativePath() {
        return FileProtocolHandler.withoutFileProtocol(this.getCycloneDxRef().getUrl());
    }

    public static boolean isSourceReference(@Nullable ExternalReference pExternalReference) {
        boolean result = pExternalReference != null && pExternalReference.getType() == ExternalReference.Type.DISTRIBUTION && SOURCE_ARCHIVE_LOCAL.equals(pExternalReference.getComment());
        return result;
    }

    public void setRelativePath(@Nullable String pRelativePath) {
        String relativePath = pRelativePath;
        if (pRelativePath != null) {
            relativePath = pRelativePath.replaceAll(Pattern.quote("\\"), "/");
        }
        this.getCycloneDxRef().setUrl(FileProtocolHandler.ensureFileProtocol(relativePath));
        this.getCycloneDxRef().setComment(SOURCE_ARCHIVE_LOCAL);
    }
}

