/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.sbom.standardbom.model;

import com.siemens.sbom.standardbom.internal.PropertyProcessor;
import com.siemens.sbom.standardbom.internal.VersionUtil;
import com.siemens.sbom.standardbom.model.BomEntry;
import com.siemens.sbom.standardbom.model.ExternalComponent;
import com.siemens.sbom.standardbom.model.SbomNature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.definition.Definition;
import org.cyclonedx.model.definition.Standard;
import org.cyclonedx.model.metadata.ToolInformation;

public class StandardBom {
    public static final String CUSTOM_PROPERTY_NAMESPACE = "siemens";
    public static final String SPEC_NAME = "Standard BOM";
    private static final String SPEC_OWNER = "Siemens AG";
    private final PropertyProcessor metaPropProc;
    private final Bom cycloneDxSbom;

    public StandardBom() {
        this(new Bom());
        this.getCycloneDxBom().setDefinitions(this.getStandardBomSpecDescriptor());
        this.getMetadata().setToolChoice(this.getStandardBomJavaLibDescriptor());
    }

    public StandardBom(@Nonnull Bom pCycloneDxSbom) {
        this.cycloneDxSbom = Objects.requireNonNull(pCycloneDxSbom, "SBOM must not be null");
        this.metaPropProc = new PropertyProcessor(() -> this.getMetadata().getProperties(), p -> this.getMetadata().addProperty(p));
    }

    private Definition getStandardBomSpecDescriptor() {
        Standard standard = new Standard();
        standard.setBomRef(VersionUtil.getSpecName());
        standard.setName(SPEC_NAME);
        standard.setVersion(VersionUtil.getSpecVersion());
        standard.setDescription("The Standard for Software Bills of Materials in Siemens");
        standard.setOwner(SPEC_OWNER);
        ExternalReference website = new ExternalReference();
        website.setType(ExternalReference.Type.WEBSITE);
        website.setUrl(VersionUtil.getSpecWebsite());
        standard.setExternalReferences(Collections.singletonList(website));
        Definition result = new Definition();
        ArrayList<Standard> standards = new ArrayList<Standard>();
        standards.add(standard);
        result.setStandards(standards);
        return result;
    }

    private ToolInformation getStandardBomJavaLibDescriptor() {
        Component javaLib = new Component();
        javaLib.setType(Component.Type.LIBRARY);
        javaLib.setGroup(VersionUtil.getLibraryGroup());
        javaLib.setName(VersionUtil.getLibraryName());
        javaLib.setVersion(VersionUtil.getLibraryVersion());
        javaLib.setDescription(VersionUtil.getLibraryDescription());
        OrganizationalEntity supplier = new OrganizationalEntity();
        supplier.setName(SPEC_OWNER);
        javaLib.setSupplier(supplier);
        ExternalReference website = new ExternalReference();
        website.setType(ExternalReference.Type.WEBSITE);
        website.setUrl(VersionUtil.getLibraryWebsite());
        javaLib.setExternalReferences(Collections.singletonList(website));
        ToolInformation result = new ToolInformation();
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(javaLib);
        result.setComponents(components);
        return result;
    }

    @Nonnull
    public Date getTimestamp() {
        Date timestamp = this.getMetadata().getTimestamp();
        if (timestamp == null) {
            timestamp = new Date(0L);
        }
        return timestamp;
    }

    public void setTimestamp(@Nonnull Date pTimestamp) {
        this.getMetadata().setTimestamp(Objects.requireNonNull(pTimestamp, "timestamp cannot be null"));
    }

    public Metadata getMetadata() {
        Metadata result = this.cycloneDxSbom.getMetadata();
        if (result == null) {
            result = new Metadata();
            this.cycloneDxSbom.setMetadata(result);
        }
        return result;
    }

    @Nonnull
    public List<BomEntry> getComponents() {
        if (this.cycloneDxSbom.getComponents() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.cycloneDxSbom.getComponents().stream().map(BomEntry::new).collect(Collectors.toList()));
    }

    public void addComponent(@Nonnull BomEntry pBomEntry) {
        this.cycloneDxSbom.addComponent(pBomEntry.getCycloneDxComponent());
    }

    @Nonnull
    public List<Dependency> getDependencies() {
        ArrayList result = this.cycloneDxSbom.getDependencies();
        if (result == null) {
            result = new ArrayList();
            this.cycloneDxSbom.setDependencies(result);
        }
        return result;
    }

    public void addDependency(@Nonnull Dependency pDependency) {
        this.cycloneDxSbom.addDependency(Objects.requireNonNull(pDependency));
    }

    @Nonnull
    public List<ExternalComponent> getExternalComponents() {
        ArrayList<ExternalComponent> result = new ArrayList<ExternalComponent>();
        if (this.cycloneDxSbom.getExternalReferences() != null) {
            for (ExternalReference extRef : this.cycloneDxSbom.getExternalReferences()) {
                if (!ExternalComponent.isExternalComponent(extRef)) continue;
                result.add(new ExternalComponent(extRef));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public void addExternalComponent(@Nonnull ExternalComponent pExternalComponent) {
        this.cycloneDxSbom.addExternalReference(pExternalComponent.getCycloneDxRef());
    }

    public void setProfile(@Nullable String pProfile) {
        this.metaPropProc.set("profile", pProfile);
    }

    @CheckForNull
    public String getProfile() {
        return this.metaPropProc.get("profile");
    }

    public void setSbomNature(@Nullable SbomNature pNature) {
        this.metaPropProc.set("sbomNature", pNature != null ? pNature.name().toLowerCase(Locale.ENGLISH) : null);
    }

    @CheckForNull
    public SbomNature getSbomNature() {
        return SbomNature.parseNature(this.metaPropProc.get("sbomNature"));
    }

    public void setSerialNumber(@Nullable String pSerialNumber) {
        this.cycloneDxSbom.setSerialNumber(pSerialNumber);
    }

    @CheckForNull
    public String getSerialNumber() {
        return this.cycloneDxSbom.getSerialNumber();
    }

    @CheckForNull
    public String getStandardBomVersion() {
        String result = this.getStandardBomVersionFromStandards();
        if (result == null) {
            result = this.getStandardBomVersionFromTools();
        }
        return result;
    }

    @CheckForNull
    private String getStandardBomVersionFromStandards() {
        List standards;
        String result = null;
        Definition definitions = this.getCycloneDxBom().getDefinitions();
        if (definitions != null && (standards = definitions.getStandards()) != null) {
            for (Standard standard : standards) {
                if (!SPEC_NAME.equals(standard.getName()) || !SPEC_OWNER.equals(standard.getOwner())) continue;
                result = standard.getVersion();
                break;
            }
        }
        return result;
    }

    @CheckForNull
    private String getStandardBomVersionFromTools() {
        String result = null;
        List tools = this.getMetadata().getTools();
        if (tools != null) {
            for (Tool tool : tools) {
                if (!"standard-bom".equals(tool.getName()) || !SPEC_OWNER.equals(tool.getVendor())) continue;
                result = tool.getVersion();
                break;
            }
        }
        return result;
    }

    @Nonnull
    public Bom getCycloneDxBom() {
        return this.cycloneDxSbom;
    }
}

