/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.DecisionStatusRequest;
import com.siftscience.EventRequest;
import com.siftscience.FieldSet;
import com.siftscience.LabelRequest;
import com.siftscience.ScoreRequest;
import com.siftscience.UnlabelRequest;
import com.siftscience.WorkflowStatusRequest;
import com.siftscience.model.DecisionStatusFieldSet;
import com.siftscience.model.LabelFieldSet;
import com.siftscience.model.ScoreFieldSet;
import com.siftscience.model.UnlabelFieldSet;
import com.siftscience.model.WorkflowStatusFieldSet;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class SiftClient {
    private String apiKey;
    private OkHttpClient okClient = new OkHttpClient();
    private HttpUrl baseUrl = HttpUrl.parse((String)"https://api.siftscience.com");
    private HttpUrl baseApi3Url = HttpUrl.parse((String)"https://api3.siftscience.com");

    public SiftClient(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public EventRequest buildRequest(FieldSet fields) {
        this.setupApiKey(fields);
        return new EventRequest(this.baseUrl, this.okClient, fields);
    }

    public DecisionStatusRequest buildRequest(DecisionStatusFieldSet fields) {
        this.setupApiKey(fields);
        return new DecisionStatusRequest(this.baseApi3Url, this.okClient, fields);
    }

    public LabelRequest buildRequest(LabelFieldSet fields) {
        this.setupApiKey(fields);
        return new LabelRequest(this.baseUrl, this.okClient, fields);
    }

    public UnlabelRequest buildRequest(UnlabelFieldSet fields) {
        this.setupApiKey(fields);
        return new UnlabelRequest(this.baseUrl, this.okClient, fields);
    }

    public ScoreRequest buildRequest(ScoreFieldSet fields) {
        this.setupApiKey(fields);
        return new ScoreRequest(this.baseUrl, this.okClient, fields);
    }

    public WorkflowStatusRequest buildRequest(WorkflowStatusFieldSet fields) {
        this.setupApiKey(fields);
        return new WorkflowStatusRequest(this.baseApi3Url, this.okClient, fields);
    }

    private void setupApiKey(FieldSet fields) {
        if (fields.getApiKey() == null) {
            fields.setApiKey(this.apiKey);
        }
    }

    SiftClient setBaseUrl(HttpUrl baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    SiftClient setBaseApi3Url(HttpUrl baseApi3Url) {
        this.baseApi3Url = baseApi3Url;
        return this;
    }
}

