/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.FieldSet;
import com.siftscience.GetMerchantsResponse;
import com.siftscience.SiftMerchantRequest;
import com.siftscience.model.GetMerchantsFieldSet;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class GetMerchantsRequest
extends SiftMerchantRequest<GetMerchantsResponse> {
    private static String DEFAULT_BATCH_SIZE = "1000";

    GetMerchantsRequest(HttpUrl baseUrl, String accountId, OkHttpClient okClient, FieldSet fields) {
        super(baseUrl, accountId, okClient, fields);
    }

    @Override
    protected HttpUrl path(HttpUrl baseUrl) {
        GetMerchantsFieldSet fieldSet = (GetMerchantsFieldSet)this.fieldSet;
        HttpUrl.Builder path = baseUrl.newBuilder("/v3/accounts").addPathSegment(this.getAccountId()).addPathSegment("psp_management").addPathSegment("merchants");
        if (fieldSet.getBatchSize() != null) {
            path.addQueryParameter(Query.BATCH_SIZE.toString(), fieldSet.getBatchSize());
        } else {
            path.addQueryParameter(Query.BATCH_SIZE.toString(), DEFAULT_BATCH_SIZE);
        }
        if (fieldSet.getBatchToken() != null) {
            path.addQueryParameter(Query.BATCH_TOKEN.toString(), String.valueOf(fieldSet.getBatchToken()));
        }
        return path.build();
    }

    @Override
    GetMerchantsResponse buildResponse(Response response, FieldSet requestFields) throws IOException {
        return new GetMerchantsResponse(response, requestFields);
    }

    @Override
    protected void modifyRequestBuilder(Request.Builder builder) {
        super.modifyRequestBuilder(builder);
        builder.header("Authorization", Credentials.basic((String)this.fieldSet.getApiKey(), (String)"")).get();
    }

    public static enum Query {
        BATCH_TOKEN("batch_token"),
        BATCH_SIZE("batch_size");

        private final String value;

        private Query(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

