/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.Constants;
import com.siftscience.FieldSet;
import com.siftscience.SiftMerchantResponse;
import com.siftscience.exception.MerchantAPIException;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class SiftMerchantRequest<T extends SiftMerchantResponse> {
    private final String accountId;
    FieldSet fieldSet;
    private OkHttpClient okClient;
    private HttpUrl baseUrl;

    protected abstract HttpUrl path(HttpUrl var1);

    public HttpUrl url() {
        return this.path(this.baseUrl);
    }

    SiftMerchantRequest(HttpUrl baseUrl, String accountId, OkHttpClient okClient, FieldSet fields) {
        this.baseUrl = baseUrl;
        this.accountId = accountId;
        this.okClient = okClient;
        this.fieldSet = fields;
    }

    protected void modifyRequestBuilder(Request.Builder builder) {
        builder.header("Authorization", Credentials.basic((String)this.fieldSet.getApiKey(), (String)"")).get();
        builder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.fieldSet.toJson()));
    }

    abstract T buildResponse(Response var1, FieldSet var2) throws IOException;

    public T send() throws IOException {
        this.fieldSet.validate();
        Request.Builder okRequestBuilder = new Request.Builder().addHeader("User-Agent", Constants.USER_AGENT_HEADER).url(this.url());
        this.modifyRequestBuilder(okRequestBuilder);
        Request request = okRequestBuilder.build();
        T response = this.buildResponse(this.okClient.newCall(request).execute(), this.fieldSet);
        if (!((SiftMerchantResponse)response).isOk()) {
            throw new MerchantAPIException(((SiftMerchantResponse)response).getApiErrorMessage());
        }
        return response;
    }

    public FieldSet getFieldSet() {
        return this.fieldSet;
    }

    protected String getAccountId() {
        return this.accountId;
    }
}

