/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.Constants;
import com.siftscience.FieldSet;
import com.siftscience.SiftResponse;
import com.siftscience.exception.InvalidApiKeyException;
import com.siftscience.exception.InvalidFieldException;
import com.siftscience.exception.InvalidRequestException;
import com.siftscience.exception.MissingFieldException;
import com.siftscience.exception.RateLimitException;
import com.siftscience.exception.ServerException;
import com.siftscience.exception.SiftException;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class SiftRequest<T extends SiftResponse> {
    private final String accountId;
    FieldSet fieldSet;
    private OkHttpClient okClient;
    private HttpUrl baseUrl;

    protected abstract HttpUrl path(HttpUrl var1);

    public HttpUrl url() {
        return this.path(this.baseUrl);
    }

    SiftRequest(HttpUrl baseUrl, String accountId, OkHttpClient okClient, FieldSet fields) {
        this.baseUrl = baseUrl;
        this.accountId = accountId;
        this.okClient = okClient;
        this.fieldSet = fields;
    }

    protected void modifyRequestBuilder(Request.Builder builder) {
        builder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.fieldSet.toJson()));
    }

    abstract T buildResponse(Response var1, FieldSet var2) throws IOException;

    public T send() throws IOException {
        this.fieldSet.validate();
        Request.Builder okRequestBuilder = new Request.Builder().addHeader("User-Agent", Constants.USER_AGENT_HEADER).url(this.url());
        this.modifyRequestBuilder(okRequestBuilder);
        Request request = okRequestBuilder.build();
        T response = this.buildResponse(this.okClient.newCall(request).execute(), this.fieldSet);
        if (!((SiftResponse)response).isOk()) {
            int httpCode = ((SiftResponse)response).getHttpStatusCode();
            Integer siftCode = ((SiftResponse)response).getApiStatus();
            if (httpCode >= 500 && httpCode < 600) {
                throw new ServerException((SiftResponse)response);
            }
            if (httpCode >= 400 && httpCode < 500) {
                if (siftCode == null) {
                    throw new ServerException((SiftResponse)response);
                }
                switch (siftCode) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: {
                        throw new ServerException((SiftResponse)response);
                    }
                    case 51: {
                        throw new InvalidApiKeyException((SiftResponse)response);
                    }
                    case 52: 
                    case 53: 
                    case 105: {
                        throw new InvalidFieldException((SiftResponse)response);
                    }
                    case 55: {
                        throw new MissingFieldException((SiftResponse)response);
                    }
                    case 56: 
                    case 57: 
                    case 104: {
                        throw new InvalidRequestException((SiftResponse)response);
                    }
                    case 60: {
                        throw new RateLimitException((SiftResponse)response);
                    }
                }
            }
            throw new SiftException((SiftResponse)response);
        }
        return response;
    }

    public FieldSet getFieldSet() {
        return this.fieldSet;
    }

    protected String getAccountId() {
        return this.accountId;
    }
}

