/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.FieldSet;
import com.siftscience.SiftMerchantRequest;
import com.siftscience.UpdateMerchantResponse;
import java.io.IOException;
import okhttp3.Credentials;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UpdateMerchantRequest
extends SiftMerchantRequest<UpdateMerchantResponse> {
    private final String merchantId;

    UpdateMerchantRequest(HttpUrl baseUrl, String accountId, OkHttpClient okClient, FieldSet fields, String merchantId) {
        super(baseUrl, accountId, okClient, fields);
        this.merchantId = merchantId;
    }

    @Override
    protected HttpUrl path(HttpUrl baseUrl) {
        HttpUrl.Builder path = baseUrl.newBuilder("/v3/accounts").addPathSegment(this.getAccountId()).addPathSegment("psp_management").addPathSegment("merchants").addPathSegments(this.getMerchantId());
        return path.build();
    }

    @Override
    UpdateMerchantResponse buildResponse(Response response, FieldSet requestFields) throws IOException {
        return new UpdateMerchantResponse(response, requestFields);
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    @Override
    protected void modifyRequestBuilder(Request.Builder builder) {
        super.modifyRequestBuilder(builder);
        builder.header("Authorization", Credentials.basic((String)this.fieldSet.getApiKey(), (String)"")).get();
        builder.put(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.fieldSet.toJson()));
    }
}

