/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.EventResponse;
import com.siftscience.FieldSet;
import com.siftscience.HttpClient;
import com.siftscience.SiftRequest;
import com.siftscience.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Response;

public class EventRequest
extends SiftRequest<EventResponse> {
    private List<String> abuseTypes = null;
    private boolean isWorkflowStatus = false;
    private boolean forceWorkflowRun = false;
    private boolean isReturnRouteInfo = false;
    private boolean returnScorePercentiles = false;
    private boolean returnWarnings = false;

    EventRequest(HttpUrl baseUrl, String accountId, HttpClient client, FieldSet fields) {
        super(baseUrl, accountId, client, fields);
    }

    @Override
    EventResponse buildResponse(Response response, FieldSet requestFields) throws IOException {
        return new EventResponse(response, requestFields);
    }

    @Override
    protected HttpUrl path(HttpUrl baseUrl) {
        HttpUrl.Builder builder = baseUrl.newBuilder().addPathSegment("v205").addPathSegment("events");
        if (this.isWorkflowStatus) {
            builder.addQueryParameter("return_workflow_status", "true");
        } else if (this.abuseTypes != null) {
            builder.addQueryParameter("return_score", "true");
        }
        if (this.isReturnRouteInfo) {
            builder.addQueryParameter("return_route_info", "true");
        }
        if (this.forceWorkflowRun) {
            builder.addQueryParameter("force_workflow_run", "true");
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (this.returnScorePercentiles) {
            fields.add("score_percentiles");
        }
        if (this.returnWarnings) {
            fields.add("warnings");
        }
        if (!fields.isEmpty()) {
            builder.addQueryParameter("fields", StringUtils.joinWithComma(fields));
        }
        if (this.abuseTypes != null && !this.abuseTypes.isEmpty()) {
            builder.addQueryParameter("abuse_types", StringUtils.joinWithComma(this.abuseTypes));
        }
        return builder.build();
    }

    public EventRequest withScores(String ... abuseTypes) {
        this.abuseTypes = Arrays.asList(abuseTypes);
        return this;
    }

    public EventRequest withWorkflowStatus() {
        this.isWorkflowStatus = true;
        return this;
    }

    public EventRequest withForceWorkflowRun() {
        this.forceWorkflowRun = true;
        return this;
    }

    public EventRequest withRouteInfo() {
        this.isReturnRouteInfo = true;
        return this;
    }

    public EventRequest withScorePercentiles() {
        this.returnScorePercentiles = true;
        return this;
    }

    public EventRequest withWarnings() {
        this.returnWarnings = true;
        return this;
    }
}

