/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.EntityScoreResponse;
import com.siftscience.FieldSet;
import com.siftscience.HttpClient;
import com.siftscience.SiftRequest;
import com.siftscience.StringUtils;
import com.siftscience.model.UserScoreFieldSet;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UserScoreRequest
extends SiftRequest<EntityScoreResponse> {
    UserScoreRequest(HttpUrl baseUrl, String accountId, HttpClient httpClient, UserScoreFieldSet fields) {
        super(baseUrl, accountId, httpClient, fields);
    }

    @Override
    protected void modifyRequestBuilder(Request.Builder builder) {
        if (((UserScoreFieldSet)this.fieldSet).getRescoreUser()) {
            builder.post(RequestBody.create(null, (byte[])new byte[0]));
        } else {
            builder.get();
        }
    }

    @Override
    EntityScoreResponse buildResponse(Response response, FieldSet requestFields) throws IOException {
        return new EntityScoreResponse(response, requestFields);
    }

    @Override
    protected HttpUrl path(HttpUrl baseUrl) {
        UserScoreFieldSet userScoreFieldSet = (UserScoreFieldSet)this.fieldSet;
        HttpUrl.Builder builder = baseUrl.newBuilder().addPathSegment("v205");
        builder.addPathSegment("users").addPathSegment(userScoreFieldSet.getUserId()).addPathSegment("score").addQueryParameter("api_key", userScoreFieldSet.getApiKey());
        if (userScoreFieldSet.getAbuseTypes() != null && !userScoreFieldSet.getAbuseTypes().isEmpty()) {
            String queryParamVal = StringUtils.joinWithComma(userScoreFieldSet.getAbuseTypes());
            builder.addQueryParameter("abuse_types", queryParamVal);
        }
        return builder.build();
    }
}

