/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class OkHttpUtils {
    private OkHttpUtils() {
    }

    public static Response execute(Request request, OkHttpClient okClient) throws IOException {
        final CompletableFuture result = new CompletableFuture();
        okClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                result.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response httpResponse) {
                result.complete(httpResponse);
            }
        });
        try {
            return (Response)result.get();
        }
        catch (InterruptedException e) {
            result.cancel(true);
            throw new InterruptedIOException("Interrupted while waiting for reply from Sift");
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }
}

