/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.siftscience.exception.InvalidFieldException;
import com.siftscience.model.GetDecisionFieldSet;
import com.siftscience.model.GetDecisionsResponseBody;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class FieldSet<T extends FieldSet<T>> {
    public static final String API_KEY = "$api_key";
    public static final String USER_ID = "$user_id";
    public static final String SESSION_ID = "$session_id";
    public static final String EVENT_TYPE = "$type";
    public static final String IP = "$ip";
    public static final String TIME = "$time";
    public static final String IS_BAD = "$is_bad";
    public static final String ABUSE_TYPE = "$abuse_type";
    public static final String USER_EMAIL = "$user_email";
    public static final String VERIFICATION_PHONE_NUMBER = "$verification_phone_number";
    private static Gson defaultGson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    protected static Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(FieldSet.class, (Object)new FieldSetDeserializer()).registerTypeHierarchyAdapter(FieldSet.class, (Object)new FieldSetSerializer()).registerTypeAdapter(GetDecisionsResponseBody.Decision.class, (Object)new DecisionSetDeserializer()).create();
    private JsonObject customFields = new JsonObject();
    private String apiKey;

    public String getEventType() {
        return null;
    }

    protected boolean shouldJsonSerializeApiKey() {
        return false;
    }

    protected T setCustomField(String key, Number val) {
        if (this.customFieldSetup(key, val)) {
            this.customFields.addProperty(key, val);
        }
        return (T)this;
    }

    protected T setCustomField(String key, Boolean val) {
        if (this.customFieldSetup(key, val)) {
            this.customFields.addProperty(key, val);
        }
        return (T)this;
    }

    protected T setCustomField(String key, String val) {
        if (this.customFieldSetup(key, val)) {
            this.customFields.addProperty(key, val);
        }
        return (T)this;
    }

    private boolean customFieldSetup(String key, Object val) {
        if (val == null) {
            this.clearCustomField(key);
            return false;
        }
        return true;
    }

    protected T clearCustomField(String key) {
        this.customFields.remove(key);
        return (T)this;
    }

    protected T clearCustomFields() {
        this.customFields.entrySet().clear();
        return (T)this;
    }

    public void validate() {
        for (Map.Entry entry : this.customFields.entrySet()) {
            if (!((String)entry.getKey()).startsWith("$")) continue;
            throw new InvalidFieldException("Custom field \"" + (String)entry.getKey() + "\" may not begin with a dollar sign.");
        }
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    protected final String getApiKey() {
        return this.apiKey;
    }

    T setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return (T)this;
    }

    private static class FieldSetDeserializer
    implements JsonDeserializer<FieldSet> {
        private FieldSetDeserializer() {
        }

        public FieldSet deserialize(JsonElement json, Type t, JsonDeserializationContext ctx) {
            JsonPrimitive p;
            FieldSet fieldSet = (FieldSet)defaultGson.fromJson(json, t);
            JsonObject jsonObj = json.getAsJsonObject();
            if (jsonObj.has(FieldSet.API_KEY) && (p = jsonObj.getAsJsonPrimitive(FieldSet.API_KEY)) != null && !p.isJsonNull()) {
                if (!p.isString()) {
                    throw new InvalidFieldException("API key must be a string.");
                }
                fieldSet.setApiKey(p.getAsString());
            }
            for (Map.Entry entry : jsonObj.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement val = (JsonElement)entry.getValue();
                if (key.startsWith("$") || val.isJsonNull()) continue;
                if (!val.isJsonPrimitive()) {
                    throw new InvalidFieldException("\"" + key + "\" must be eithera number, boolean, string, or null.");
                }
                JsonPrimitive primitiveVal = val.getAsJsonPrimitive();
                if (primitiveVal.isString()) {
                    fieldSet.setCustomField(key, primitiveVal.getAsString());
                    continue;
                }
                if (primitiveVal.isNumber()) {
                    fieldSet.setCustomField(key, primitiveVal.getAsNumber());
                    continue;
                }
                if (!primitiveVal.isBoolean()) continue;
                fieldSet.setCustomField(key, primitiveVal.getAsBoolean());
            }
            return fieldSet;
        }
    }

    private static class FieldSetSerializer
    implements JsonSerializer<FieldSet> {
        private FieldSetSerializer() {
        }

        public JsonElement serialize(FieldSet src, Type t, JsonSerializationContext ctx) {
            JsonObject jsonObj = defaultGson.toJsonTree((Object)src).getAsJsonObject();
            for (Map.Entry entry : src.customFields.entrySet()) {
                jsonObj.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            jsonObj.addProperty(FieldSet.EVENT_TYPE, src.getEventType());
            if (src.shouldJsonSerializeApiKey()) {
                jsonObj.addProperty(FieldSet.API_KEY, src.getApiKey());
            }
            return jsonObj;
        }
    }

    private static class DecisionSetDeserializer
    implements JsonDeserializer<GetDecisionsResponseBody.Decision> {
        private DecisionSetDeserializer() {
        }

        public GetDecisionsResponseBody.Decision deserialize(JsonElement json, Type t, JsonDeserializationContext ctx) throws JsonParseException {
            GetDecisionsResponseBody.Decision decision = (GetDecisionsResponseBody.Decision)defaultGson.fromJson(json, t);
            JsonObject asJsonObject = json.getAsJsonObject();
            if (asJsonObject.has("abuse_type")) {
                try {
                    decision.setAbuseType(GetDecisionFieldSet.AbuseType.valueOf(asJsonObject.get("abuse_type").getAsString().toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (asJsonObject.has("category")) {
                try {
                    decision.setCategory(GetDecisionFieldSet.DecisionCategory.valueOf(asJsonObject.get("category").getAsString().toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (asJsonObject.has("entity_type")) {
                try {
                    decision.setEntityType(GetDecisionFieldSet.EntityType.valueOf(asJsonObject.get("entity_type").getAsString().toUpperCase()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return decision;
        }
    }
}

