/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.ApplyDecisionRequest;
import com.siftscience.CreateMerchantRequest;
import com.siftscience.DecisionStatusRequest;
import com.siftscience.EventRequest;
import com.siftscience.FieldSet;
import com.siftscience.GetDecisionsRequest;
import com.siftscience.GetMerchantRequest;
import com.siftscience.GetMerchantsRequest;
import com.siftscience.HttpClient;
import com.siftscience.LabelRequest;
import com.siftscience.ScoreRequest;
import com.siftscience.UnlabelRequest;
import com.siftscience.UpdateMerchantRequest;
import com.siftscience.UserScoreRequest;
import com.siftscience.VerificationCheckRequest;
import com.siftscience.VerificationResendRequest;
import com.siftscience.VerificationSendRequest;
import com.siftscience.WorkflowStatusRequest;
import com.siftscience.model.ApplyDecisionFieldSet;
import com.siftscience.model.CreateMerchantFieldSet;
import com.siftscience.model.DecisionStatusFieldSet;
import com.siftscience.model.GetDecisionFieldSet;
import com.siftscience.model.GetMerchantFieldSet;
import com.siftscience.model.GetMerchantsFieldSet;
import com.siftscience.model.LabelFieldSet;
import com.siftscience.model.ScoreFieldSet;
import com.siftscience.model.UnlabelFieldSet;
import com.siftscience.model.UpdateMerchantFieldSet;
import com.siftscience.model.UserScoreFieldSet;
import com.siftscience.model.VerificationCheckFieldSet;
import com.siftscience.model.VerificationResendFieldSet;
import com.siftscience.model.VerificationSendFieldSet;
import com.siftscience.model.WorkflowStatusFieldSet;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class SiftClient {
    private final String accountId;
    private final String apiKey;
    private final HttpClient httpClient;
    private HttpUrl baseUrl = HttpUrl.parse((String)"https://api.sift.com");

    public SiftClient(String apiKey, String accountId) {
        this(apiKey, accountId, new OkHttpClient());
    }

    public SiftClient(String apiKey, String accountId, OkHttpClient okHttpClient) {
        this.assertNotNull(apiKey, "API key must not be null");
        this.assertNotNull(okHttpClient, "Http Client must not be null");
        this.apiKey = apiKey;
        this.accountId = accountId;
        this.httpClient = new HttpClient(okHttpClient);
    }

    public SiftClient(String apiKey, String accountId, HttpUrl baseUrl) {
        this(apiKey, accountId, new OkHttpClient());
        this.baseUrl = baseUrl;
    }

    public SiftClient(String apiKey, String accountId, HttpUrl baseUrl, OkHttpClient okHttpClient) {
        this(apiKey, accountId, okHttpClient);
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void enqueueRequests() {
        this.httpClient.enqueueRequests();
    }

    public EventRequest buildRequest(FieldSet fields) {
        this.setupApiKey(fields);
        return new EventRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public ApplyDecisionRequest buildRequest(ApplyDecisionFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new ApplyDecisionRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public GetDecisionsRequest buildRequest(GetDecisionFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new GetDecisionsRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public DecisionStatusRequest buildRequest(DecisionStatusFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new DecisionStatusRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public LabelRequest buildRequest(LabelFieldSet fields) {
        this.setupApiKey(fields);
        return new LabelRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public UnlabelRequest buildRequest(UnlabelFieldSet fields) {
        this.setupApiKey(fields);
        return new UnlabelRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public ScoreRequest buildRequest(ScoreFieldSet fields) {
        this.setupApiKey(fields);
        return new ScoreRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public UserScoreRequest buildRequest(UserScoreFieldSet fields) {
        this.setupApiKey(fields);
        return new UserScoreRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public WorkflowStatusRequest buildRequest(WorkflowStatusFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new WorkflowStatusRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public GetMerchantsRequest buildRequest(GetMerchantsFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new GetMerchantsRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public GetMerchantRequest buildRequest(GetMerchantFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new GetMerchantRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public CreateMerchantRequest buildRequest(CreateMerchantFieldSet fields) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new CreateMerchantRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public UpdateMerchantRequest buildRequest(UpdateMerchantFieldSet fields, String merchantId) {
        this.assertAccountIdIsNotNull();
        this.setupApiKey(fields);
        return new UpdateMerchantRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields, merchantId);
    }

    public VerificationSendRequest buildRequest(VerificationSendFieldSet fields) {
        this.setupApiKey(fields);
        return new VerificationSendRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public VerificationResendRequest buildRequest(VerificationResendFieldSet fields) {
        this.setupApiKey(fields);
        return new VerificationResendRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    public VerificationCheckRequest buildRequest(VerificationCheckFieldSet fields) {
        this.setupApiKey(fields);
        return new VerificationCheckRequest(this.baseUrl, this.getAccountId(), this.httpClient, fields);
    }

    private void setupApiKey(FieldSet fields) {
        fields.setApiKey(this.getApiKey());
    }

    private void assertAccountIdIsNotNull() {
        this.assertNotNull(this.getAccountId(), "Account ID must not be null");
    }

    private void assertNotNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

